/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, sequential=true, testName="eviction.MRUConfigurationTest")
public class MRUConfigurationTest {
    MRUAlgorithmConfig config = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.config = new MRUAlgorithmConfig();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.config = null;
    }

    public void testXMLParsing() throws Exception {
        String xml = "<region name=\"/org/jboss/data\">\n<property name=\"maxNodes\" value=\"5000\"></property>\n</region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)this.config);
        this.config.validate();
        AssertJUnit.assertEquals((int)5000, (int)this.config.getMaxNodes());
    }

    public void testXMLParsing2() throws Exception {
        String xml = "<region name=\"/Test/\">\n<property name=\"maxNodes\" value=\"10000\"></property>\n</region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)this.config);
        this.config.validate();
        AssertJUnit.assertEquals((int)10000, (int)this.config.getMaxNodes());
    }

    public void testXMLParsing3() throws Exception {
        String xml = "<region name=\"/Test/\">\n</region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)this.config);
        this.config.validate();
        assert (this.config.getMaxNodes() == -1);
        xml = "<region name=\"/Test/\">\n<property name=\"maxNodes\" value=\"10000\"></property>\n</region>";
        element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)this.config);
        this.config.validate();
        AssertJUnit.assertEquals((int)10000, (int)this.config.getMaxNodes());
    }
}

