/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.NullEvictionAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionWatcher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.NullEvictionPolicyTest")
public class NullEvictionPolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testEviction() throws InterruptedException {
        Fqn lru;
        Fqn test;
        Fqn dflt;
        int i;
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new NullEvictionAlgorithmConfig(), 200000), 200);
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/test"), (EvictionAlgorithmConfig)new NullEvictionAlgorithmConfig()));
        evConfig.addEvictionRegionConfig(new EvictionRegionConfig(Fqn.fromString((String)"/lru"), (EvictionAlgorithmConfig)new LRUAlgorithmConfig(1000L, 10000L)));
        config.setEvictionConfig(evConfig);
        config.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        config.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(config);
        String dfltRootStr = "/a/";
        String testRootStr = "/test/";
        String lruRootStr = "/lru/";
        ArrayList<Fqn> toBeEvicted = new ArrayList<Fqn>();
        for (int i2 = 0; i2 < 20; ++i2) {
            toBeEvicted.add(Fqn.fromString((String)(lruRootStr + i2)));
        }
        EvictionWatcher watcher = new EvictionWatcher((Cache<?, ?>)this.cache, (List<Fqn>)toBeEvicted);
        for (i = 0; i < 20; ++i) {
            dflt = Fqn.fromString((String)(dfltRootStr + i));
            test = Fqn.fromString((String)(testRootStr + i));
            lru = Fqn.fromString((String)(lruRootStr + i));
            this.cache.put(dflt, (Object)"key", (Object)"value");
            this.cache.put(test, (Object)"key", (Object)"value");
            this.cache.put(lru, (Object)"key", (Object)"value");
        }
        assert (watcher.waitForEviction(30L, TimeUnit.SECONDS));
        for (i = 0; i < 20; ++i) {
            dflt = Fqn.fromString((String)(dfltRootStr + i));
            test = Fqn.fromString((String)(testRootStr + i));
            lru = Fqn.fromString((String)(lruRootStr + i));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(dflt, (Object)"key"));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get(test, (Object)"key"));
            AssertJUnit.assertNull((Object)this.cache.get(lru, (Object)"key"));
        }
    }
}

