/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.Collections;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.CustomInterceptorConfig;
import org.jboss.cache.config.parsing.custominterceptors.AaaCustomInterceptor;
import org.jboss.cache.interceptors.MVCCLockingInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=true, testName="factories.CustomInterceptorConstructionTest")
public class CustomInterceptorConstructionTest {
    CacheSPI cache;
    int defaultInterceptroCount;

    @AfterMethod
    public void tearDown() {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
        }
        this.cache = null;
    }

    public void testAddFirst() {
        AaaCustomInterceptor interceptor = new AaaCustomInterceptor();
        CustomInterceptorConfig config = new CustomInterceptorConfig((CommandInterceptor)interceptor);
        config.setFirst(true);
        this.buildCache(config);
        assert (this.cache.getInterceptorChain().get(0).equals((Object)interceptor));
        assert (this.cache.getInterceptorChain().size() == this.defaultInterceptroCount + 1);
    }

    public void testAddLast() {
        AaaCustomInterceptor interceptor = new AaaCustomInterceptor();
        CustomInterceptorConfig config = new CustomInterceptorConfig((CommandInterceptor)interceptor);
        config.setLast(true);
        this.buildCache(config);
        List chain = this.cache.getInterceptorChain();
        assert (chain.get(chain.size() - 1).equals((Object)interceptor));
        assert (this.cache.getInterceptorChain().size() == this.defaultInterceptroCount + 1);
    }

    public void testAddAfter() {
        AaaCustomInterceptor interceptor = new AaaCustomInterceptor();
        CustomInterceptorConfig config = new CustomInterceptorConfig((CommandInterceptor)interceptor);
        config.setAfterClass(MVCCLockingInterceptor.class.getName());
        this.buildCache(config);
        List chain = this.cache.getInterceptorChain();
        int occurenceCount = 0;
        for (CommandInterceptor ci : chain) {
            if (!(ci instanceof MVCCLockingInterceptor)) continue;
            assert (ci.getNext().equals((Object)interceptor));
            ++occurenceCount;
        }
        assert (occurenceCount == 1);
        assert (this.cache.getInterceptorChain().size() == this.defaultInterceptroCount + 1);
    }

    public void testAddBefore() {
        AaaCustomInterceptor interceptor = new AaaCustomInterceptor();
        CustomInterceptorConfig config = new CustomInterceptorConfig((CommandInterceptor)interceptor);
        config.setBeforeClass(MVCCLockingInterceptor.class.getName());
        this.buildCache(config);
        List chain = this.cache.getInterceptorChain();
        int occurenceCount = 0;
        for (CommandInterceptor ci : chain) {
            if (!(ci instanceof AaaCustomInterceptor)) continue;
            assert (ci.getNext() instanceof MVCCLockingInterceptor);
            ++occurenceCount;
        }
        assert (occurenceCount == 1);
        assert (this.cache.getInterceptorChain().size() == this.defaultInterceptroCount + 1);
    }

    @Test(enabled=true)
    public void testAddAtIndex() {
        AaaCustomInterceptor interceptor = new AaaCustomInterceptor();
        CustomInterceptorConfig config = new CustomInterceptorConfig((CommandInterceptor)interceptor);
        config.setIndex(1);
        this.buildCache(config);
        List chain = this.cache.getInterceptorChain();
        assert (((CommandInterceptor)chain.get(1)).equals((Object)interceptor));
        assert (this.cache.getInterceptorChain().size() == this.defaultInterceptroCount + 1);
    }

    public void testAddAtInvalidIndex() {
        AaaCustomInterceptor interceptor = new AaaCustomInterceptor();
        CustomInterceptorConfig config = new CustomInterceptorConfig((CommandInterceptor)interceptor);
        config.setIndex(1000);
        try {
            this.buildCache(config);
            assert (false) : "exception expected here";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildCache(CustomInterceptorConfig interceptorConfig) {
        this.buildCache(Collections.singletonList(interceptorConfig));
    }

    private void buildCache(List<CustomInterceptorConfig> interceptorConfig) {
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        UnitTestCacheFactory cacheFactory2 = new UnitTestCacheFactory();
        CacheSPI tmpCacheSPI = (CacheSPI)cacheFactory2.createCache(config);
        this.defaultInterceptroCount = tmpCacheSPI.getInterceptorChain().size();
        tmpCacheSPI.stop();
        UnitTestCacheFactory cacheFactory = new UnitTestCacheFactory();
        config.setCustomInterceptors(interceptorConfig);
        this.cache = (CacheSPI)cacheFactory.createCache(config, true);
    }
}

