/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.Iterator;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.factories.InterceptorChainTestBase;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.BatchingInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.EvictionInterceptor;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.LegacyActivationInterceptor;
import org.jboss.cache.interceptors.LegacyCacheLoaderInterceptor;
import org.jboss.cache.interceptors.LegacyCacheStoreInterceptor;
import org.jboss.cache.interceptors.LegacyDataGravitatorInterceptor;
import org.jboss.cache.interceptors.LegacyPassivationInterceptor;
import org.jboss.cache.interceptors.MVCCLockingInterceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.OptimisticTxInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.ReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="factories.InterceptorChainFactoryTest")
public class InterceptorChainFactoryTest
extends InterceptorChainTestBase {
    CacheSPI cache = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setCacheMode(Configuration.CacheMode.LOCAL);
        configuration.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        configuration.setUseLazyDeserialization(false);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(configuration, false);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testBareConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testBareConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)5, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testBatchingConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setInvocationBatchingEnabled(true);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testBareConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(BatchingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testMvccConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testMvccConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)5, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(MVCCLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testTxConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testTxConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)5, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    protected CacheLoaderConfig getCacheLoaderConfig(boolean pasv, boolean fetchPersistentState) throws Exception {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
        iclc.setFetchPersistentState(fetchPersistentState);
        clc.addIndividualCacheLoaderConfig(iclc);
        clc.setPassivation(pasv);
        return clc;
    }

    public void testSharedCacheLoaderConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, false));
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setFetchInMemoryState(false);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testSharedCacheLoaderConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyCacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyCacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testSharedCacheLoaderMvccConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, false));
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        this.cache.getConfiguration().setFetchInMemoryState(false);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testSharedCacheLoaderConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(MVCCLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testUnsharedCacheLoaderConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, true));
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setFetchInMemoryState(false);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testUnsharedCacheLoaderConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyCacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyCacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testUnsharedCacheLoaderMvccConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, true));
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        this.cache.getConfiguration().setFetchInMemoryState(false);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testUnsharedCacheLoaderConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(MVCCLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testTxAndRepl() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testTxAndRepl interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticReplicatedChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)9, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticCacheLoaderChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(false, false));
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)10, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyCacheLoaderInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyCacheStoreInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testOptimisticPassivationCacheLoaderChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(true, false));
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)10, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyActivationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyPassivationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testPassivationMvccChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(true, false));
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)7, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ActivationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(MVCCLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PassivationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testInvalidationInterceptorChain() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.cache.getConfiguration().setExposeManagementStatistics(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_ASYNC);
        chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        list = chain.asList();
        interceptors = list.iterator();
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(InvalidationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testCacheMgmtConfig() throws Exception {
        this.cache.getConfiguration().setExposeManagementStatistics(true);
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testCacheMgmtConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)6, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testEvictionInterceptorConfig() throws Exception {
        this.cache.getConfiguration().setEvictionConfig(new EvictionConfig(){
            private static final long serialVersionUID = -6644183636899605065L;

            public boolean isValidConfig() {
                return true;
            }
        });
        InterceptorChainFactory factory = this.getInterceptorChainFactory((Cache)this.cache);
        InterceptorChain chain = factory.buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testEvictionInterceptorConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)7, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(EvictionInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testBuddyReplicationOptLocking() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testEvictionInterceptorConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)11, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticTxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyDataGravitatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticLockingInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticValidatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticCreateIfNotExistsInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(OptimisticNodeInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    public void testBuddyReplicationPessLocking() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.cache.create();
        InterceptorChain chain = this.getInterceptorChainFactory((Cache)this.cache).buildInterceptorChain();
        List list = chain.asList();
        Iterator interceptors = list.iterator();
        System.out.println("testEvictionInterceptorConfig interceptors are:\n" + list);
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)8, (int)list.size());
        AssertJUnit.assertEquals(InvocationContextInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CacheMgmtInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(TxInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(NotificationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(ReplicationInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(PessimisticLockInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(LegacyDataGravitatorInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        AssertJUnit.assertEquals(CallInterceptor.class, ((CommandInterceptor)interceptors.next()).getClass());
        this.assertInterceptorLinkage(list);
    }

    private InterceptorChainFactory getInterceptorChainFactory(Cache cache) {
        return InterceptorChainFactory.getInstance((ComponentRegistry)TestingUtil.extractComponentRegistry(cache), (Configuration)cache.getConfiguration());
    }
}

