/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.marshall.AbstractMarshaller;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="factories.LateConfigurationTest")
public class LateConfigurationTest {
    CacheSPI c;

    @BeforeMethod
    public void setUp() {
        this.c = (CacheSPI)new UnitTestCacheFactory().createCache(false);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.c});
        this.c = null;
    }

    public void testTransactionManager() {
        assert (this.c.getTransactionManager() == null);
        this.c.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        assert (this.c.getTransactionManager() == null);
        this.c.start();
        assert (this.c.getTransactionManager() == DummyTransactionManager.getInstance());
    }

    public void testTransactionManagerinRuntime() {
        assert (this.c.getTransactionManager() == null);
        this.c.getConfiguration().getRuntimeConfig().setTransactionManager((TransactionManager)DummyTransactionManager.getInstance());
        assert (this.c.getTransactionManager() == null);
        this.c.start();
        assert (this.c.getTransactionManager() == DummyTransactionManager.getInstance());
    }

    public void testCacheLoader() {
        assert (this.c.getCacheLoaderManager() != null);
        assert (this.c.getCacheLoaderManager().getCacheLoader() == null);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setCacheLoader((CacheLoader)new DummyInMemoryCacheLoader());
        clc.addIndividualCacheLoaderConfig(iclc);
        this.c.getConfiguration().setCacheLoaderConfig(clc);
        this.c.start();
        assert (this.c.getCacheLoaderManager() != null);
        assert (this.c.getCacheLoaderManager().getCacheLoader() instanceof DummyInMemoryCacheLoader);
    }

    public void testBuddyManagerLocal() {
        assert (this.c.getBuddyManager() == null);
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.c.getConfiguration().setBuddyReplicationConfig(brc);
        this.c.start();
        assert (this.c.getBuddyManager() == null);
    }

    public void testBuddyManager() {
        this.c.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        assert (this.c.getBuddyManager() == null);
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.c.getConfiguration().setBuddyReplicationConfig(brc);
        this.c.start();
        assert (this.c.getBuddyManager() != null);
        assert (this.c.getBuddyManager().isEnabled());
    }

    public void testInterceptors() {
        assert (TestingUtil.findInterceptor(this.c, OptimisticLockingInterceptor.class) == null);
        this.c.getConfiguration().setNodeLockingScheme("OPTIMISTIC");
        assert (TestingUtil.findInterceptor(this.c, OptimisticLockingInterceptor.class) == null);
        this.c.start();
        assert (TestingUtil.findInterceptor(this.c, OptimisticLockingInterceptor.class) != null);
    }

    public void testCacheMarshaller() {
        assert (this.c.getMarshaller() instanceof VersionAwareMarshaller);
        this.c.getConfiguration().setCacheMarshaller((Marshaller)new AbstractMarshaller(){

            public void objectToObjectStream(Object obj, ObjectOutputStream out) throws Exception {
            }

            public Object objectFromObjectStream(ObjectInputStream in) throws Exception {
                return null;
            }

            public void objectToObjectStream(Object obj, ObjectOutputStream out, Fqn region) {
            }
        });
        this.c.start();
        assert (!(this.c.getMarshaller() instanceof VersionAwareMarshaller) && this.c.getMarshaller() != null);
    }
}

