/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.integration.hibernate;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.integration.hibernate.HibernateIntegrationTestUtil;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"integration"}, sequential=true, testName="integration.hibernate.UpdateTimestampsCachingTest")
public class UpdateTimestampsCachingTest {
    private static final Log log = LogFactory.getLog(UpdateTimestampsCachingTest.class);
    private static final Fqn ENTITY_TYPE_FQN = Fqn.fromString((String)"/com/foo/MyEntity");
    private Set<Cache<String, Object>> caches;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.caches = new HashSet<Cache<String, Object>>();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        for (Cache<String, Object> cache : this.caches) {
            TestingUtil.killCaches(cache);
        }
        this.caches = null;
    }

    private Cache<String, Object> createCache(boolean optimistic) {
        UnitTestCacheFactory cf = new UnitTestCacheFactory();
        Cache cache = cf.createCache("configs/local-tx.xml", false);
        cache.getConfiguration().setNodeLockingScheme(optimistic ? Configuration.NodeLockingScheme.OPTIMISTIC : Configuration.NodeLockingScheme.PESSIMISTIC);
        cache.start();
        this.caches.add((Cache<String, Object>)cache);
        return cache;
    }

    public void testTimestampUpdateInAfterCompletionPessimistic() throws Exception {
        this.timestampUpdateInAfterCompletionTest(false);
    }

    public void testTimestampUpdateInAfterCompletionOptimistic() throws Exception {
        this.timestampUpdateInAfterCompletionTest(true);
    }

    private void timestampUpdateInAfterCompletionTest(boolean optimistic) throws Exception {
        Cache<String, Object> cache = this.createCache(optimistic);
        TransactionManager tm = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        tm.begin();
        Transaction tx = tm.getTransaction();
        UpdateTimestampsSynchronization sync = new UpdateTimestampsSynchronization(ENTITY_TYPE_FQN, cache, tm);
        tx.registerSynchronization((Synchronization)sync);
        Fqn fqn = Fqn.fromRelativeFqn((Fqn)HibernateIntegrationTestUtil.REGION_PREFIX_FQN, (Fqn)ENTITY_TYPE_FQN);
        fqn = Fqn.fromRelativeElements((Fqn)fqn, (Object[])new String[]{"1"});
        cache.put(fqn, (Object)"item", (Object)"value");
        tm.commit();
        fqn = Fqn.fromRelativeFqn((Fqn)HibernateIntegrationTestUtil.TS_FQN, (Fqn)ENTITY_TYPE_FQN);
        AssertJUnit.assertEquals((Object)sync.getTimestamp(), (Object)cache.get(fqn, (Object)"item"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateTimestampsSynchronization
    implements Synchronization {
        private final Cache<String, Object> cache;
        private final Fqn entityType;
        private final TransactionManager tm;
        private Long timestamp;

        UpdateTimestampsSynchronization(Fqn entityType, Cache<String, Object> cache, TransactionManager tm) {
            this.entityType = entityType;
            this.cache = cache;
            this.tm = tm;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            Fqn fqn = Fqn.fromRelativeFqn((Fqn)HibernateIntegrationTestUtil.TS_FQN, (Fqn)this.entityType);
            try {
                this.timestamp = System.currentTimeMillis();
                Transaction tx = this.tm.suspend();
                this.cache.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
                this.cache.put(fqn, (Object)"item", (Object)this.timestamp);
                this.tm.resume(tx);
                log.info((Object)("Updated timestamp " + this.entityType));
            }
            catch (Exception e) {
                log.error((Object)("Problem updating timestamp " + this.entityType), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

