/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="interceptors.LegacyInterceptorTest")
public class LegacyInterceptorTest {
    Cache cache;
    static CountDownLatch interceptorResumeLatch;
    static CountDownLatch interceptorInvokedLatch;
    TestInterceptor testInterceptor;
    Executor testRunner;

    @BeforeMethod
    public void createLatches() {
        this.cache = new UnitTestCacheFactory().createCache();
        this.testInterceptor = new TestInterceptor();
        ((CacheSPI)this.cache).addInterceptor((CommandInterceptor)this.testInterceptor, TxInterceptor.class);
        this.testRunner = Executors.newSingleThreadExecutor();
        interceptorResumeLatch = new CountDownLatch(1);
        interceptorInvokedLatch = new CountDownLatch(1);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testPut() throws Exception {
        this.testRunner.execute(new Runnable(){

            public void run() {
                LegacyInterceptorTest.this.cache.put("/a", (Object)"k", (Object)"v");
            }
        });
        interceptorInvokedLatch.await();
        MethodCall methodCall = this.testInterceptor.methodCall;
        interceptorResumeLatch.countDown();
        assert (methodCall.getMethodId() == 3);
        assert (methodCall.getArgs()[0] == null);
        assert (methodCall.getArgs()[1].equals(Fqn.fromString((String)"/a")));
        assert (methodCall.getArgs()[2].equals("k"));
        assert (methodCall.getArgs()[3].equals("v"));
        assert (methodCall.getArgs()[4] == Boolean.FALSE);
    }

    public static class TestInterceptor
    extends Interceptor {
        MethodCall methodCall;

        public Object invoke(InvocationContext ctx) throws Throwable {
            if (ctx.isOriginLocal()) {
                this.methodCall = ctx.getMethodCall();
                interceptorInvokedLatch.countDown();
                interceptorResumeLatch.await();
                this.methodCall = null;
            }
            return super.invoke(ctx);
        }
    }
}

