/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyCountingCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="loader.CacheLoaderMethodCallCounterTest")
public class CacheLoaderMethodCallCounterTest
extends AbstractCacheLoaderTestBase {
    private CacheSPI cache;
    private DummyCountingCacheLoader dummyLoader;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache != null) {
            this.tearDown();
        }
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummyCountingCacheLoader.class.getName(), "", false, false, false));
        this.cache.start();
        this.dummyLoader = (DummyCountingCacheLoader)this.cache.getCacheLoaderManager().getCacheLoader();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testPut() {
        this.cache.put("/node", (Object)"key", (Object)"value");
        this.printReport("putKeyValue", this.dummyLoader);
    }

    public void testGet() {
        this.cache.get("/node", (Object)"key");
        this.printReport("getKey", this.dummyLoader);
    }

    public void testRemove() {
        this.cache.remove("/node", (Object)"key");
        this.printReport("removeKey", this.dummyLoader);
    }

    private void printReport(String test, DummyCountingCacheLoader d) {
        System.out.println("------------------------------");
        System.out.println(" Test name: " + test);
        System.out.println("  cache loader stats:");
        System.out.println("   put count: " + d.getPutCount());
        System.out.println("   get count: " + d.getGetCount());
        System.out.println("   exists count: " + d.getExistsCount());
        System.out.println("   remove count: " + d.getRemoveCount());
        System.out.println("   getChildrenNames count: " + d.getGetChildrenNamesCount());
        System.out.println("------------------------------");
    }

    public void testLoopedGets() {
        this.cache.put("/test", (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getPutCount());
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getGetCount());
        for (int i = 0; i < 2000; ++i) {
            this.cache.getNode("/test");
        }
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getPutCount());
        AssertJUnit.assertEquals((int)1, (int)this.dummyLoader.getGetCount());
        AssertJUnit.assertEquals((int)0, (int)this.dummyLoader.getRemoveCount());
        AssertJUnit.assertEquals((int)0, (int)this.dummyLoader.getExistsCount());
    }
}

