/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestDbPropertiesFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="loader.DataSourceIntegrationTest")
public class DataSourceIntegrationTest
extends AbstractCacheLoaderTestBase {
    private final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";
    private final String JNDI_NAME = "java:/MockDS";
    private CacheSPI cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        DummyTransactionManager.getInstance();
    }

    protected CacheLoaderConfig getCacheLoaderConfig(Properties jndi) throws Exception {
        Properties props = new Properties(jndi);
        props.put("cache.jdbc.datasource", "java:/MockDS");
        props.put("cache.jdbc.table.create", (Object)true);
        props.put("cache.jdbc.table.drop", (Object)true);
        return this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props, false, false, false);
    }

    public void testDataSourceIntegration() throws Exception {
        InitialContext context = new InitialContext();
        try {
            Object obj = context.lookup("java:/MockDS");
            AssertJUnit.assertNull((String)"java:/MockDS not bound", (Object)obj);
        }
        catch (NameNotFoundException n) {
            // empty catch block
        }
        Properties props = TestDbPropertiesFactory.getTestDbProperties();
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig(props));
        this.cache.create();
        context.bind("java:/MockDS", (Object)new MockDataSource(props));
        AssertJUnit.assertNotNull((String)"java:/MockDS bound", (Object)context.lookup("java:/MockDS"));
        this.cache.start();
        AssertJUnit.assertNotNull((String)"Cache has a cache loader", (Object)this.cache.getCacheLoaderManager().getCacheLoader());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.unbind("java:/MockDS");
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockDataSource
    implements DataSource {
        private String userName;
        private String jdbcUrl;
        private String jdbcPassword;

        public MockDataSource(Properties properties) {
            try {
                Class.forName(properties.getProperty("cache.jdbc.driver"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.userName = properties.getProperty("cache.jdbc.user");
            this.jdbcUrl = properties.getProperty("cache.jdbc.url");
            this.jdbcPassword = properties.getProperty("cache.jdbc.password");
        }

        @Override
        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(this.jdbcUrl, this.userName, this.jdbcPassword);
        }

        @Override
        public Connection getConnection(String user, String password) throws SQLException {
            return DriverManager.getConnection(this.jdbcUrl, this.userName, this.jdbcPassword);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> ifc) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }
    }
}

