/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.derby.jdbc.EmbeddedXADataSource;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestDbPropertiesFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="loader.JDBCCacheLoaderDerbyDSTest")
public class JDBCCacheLoaderDerbyDSTest
extends CacheLoaderTestsBase {
    private final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";
    private final String JNDI_NAME = "java:/DerbyDS";

    protected void configureCache() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        DummyTransactionManager.getInstance();
        InitialContext context = new InitialContext();
        try {
            Object obj = context.lookup("java:/DerbyDS");
            AssertJUnit.assertNull((String)"java:/DerbyDS not bound", (Object)obj);
        }
        catch (NameNotFoundException n) {
            // empty catch block
        }
        Properties prop = TestDbPropertiesFactory.getTestDbProperties();
        EmbeddedXADataSource ds = new EmbeddedXADataSource();
        ds.setDatabaseName("jbossdb");
        ds.setCreateDatabase("create");
        ds.setUser(prop.getProperty("cache.jdbc.user"));
        ds.setPassword(prop.getProperty("cache.jdbc.password"));
        String props = "cache.jdbc.datasource =java:/DerbyDS\ncache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" + "cache.jdbc.sql-concat= 1 || 2" + "\n" + "cache.jdbc.table.name=jbosscache" + TestingUtil.getThreadId() + "\n" + "cache.jdbc.table.primarykey=jbosscache_pk" + TestingUtil.getThreadId();
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.JDBCCacheLoader", props, false, true, false));
        cache.create();
        context.bind("java:/DerbyDS", (Object)ds);
        AssertJUnit.assertNotNull((String)"java:/DerbyDS bound", (Object)context.lookup("java:/DerbyDS"));
    }

    public void testLargeObject() {
        CacheLoader loader = (CacheLoader)this.loaderTL.get();
        try {
            String key = "LargeObj";
            StringBuilder text = new StringBuilder("LargeObject");
            while (text.toString().getBytes().length < 102400) {
                text.append((CharSequence)text);
            }
            String initialValue = text.toString();
            loader.remove(Fqn.fromString((String)"/"));
            Object retVal = loader.put(FQN, (Object)key, (Object)initialValue);
            AssertJUnit.assertNull((Object)retVal);
            this.addDelay();
            AssertJUnit.assertEquals((String)initialValue, (String)((String)loader.get(FQN).get(key)));
            String updatedValue = initialValue.concat("UpdatedValue");
            retVal = loader.put(FQN, (Object)key, (Object)updatedValue);
            AssertJUnit.assertEquals((String)initialValue, (String)((String)retVal));
            AssertJUnit.assertEquals((String)updatedValue, (String)((String)loader.get(FQN).get(key)));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testTransactionRollback() throws Exception {
    }

    public void testIntegratedTransactionRollback() throws Exception {
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        Properties icProps = new Properties();
        icProps.setProperty("java.naming.factory.initial", "org.jboss.cache.transaction.DummyContextFactory");
        InitialContext ctx = new InitialContext(icProps);
        ctx.unbind("java:/DerbyDS");
    }
}

