/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="loader.PreloadTest")
public class PreloadTest
extends AbstractCacheLoaderTestBase {
    CacheSPI<Object, Object> cache;
    Fqn fqn = Fqn.fromString((String)"/a/b/c");
    Object key = "key";
    Object value = "value";

    @AfterMethod
    public void tearDown() {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
        }
        this.cache = null;
    }

    public void testPreload() throws Exception {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL);
        String props = "bin=" + this.getClass().getName();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("/a", DummySharedInMemoryCacheLoader.class.getName(), props, false, false, false));
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c.clone());
        this.cache.put(this.fqn, this.key, this.value);
        this.assertExists();
        this.cache.destroy();
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c.clone());
        this.assertExists();
    }

    public void testPreloadMultiRegions() throws Exception {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL);
        String props = "bin=" + this.getClass().getName();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("/a", DummySharedInMemoryCacheLoader.class.getName(), props, false, false, false));
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c.clone());
        this.cache.put(this.fqn, this.key, this.value);
        this.assertExists();
        this.cache.destroy();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("/c,/a,/b", DummySharedInMemoryCacheLoader.class.getName(), props, false, false, false));
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c.clone());
        this.assertExists();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("/c, /a, /b", DummySharedInMemoryCacheLoader.class.getName(), props, false, false, false));
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c.clone());
        this.assertExists();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("  /c,   /a,   /b", DummySharedInMemoryCacheLoader.class.getName(), props, false, false, false));
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c.clone());
        this.assertExists();
    }

    private void assertExists() throws Exception {
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        assert (loader.get(this.fqn).get(this.key).equals(this.value));
        assert (this.cache.peek(this.fqn, false).getDataDirect().get(this.key).equals(this.value));
    }
}

