/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.GenericTransactionManagerLookup;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=true, testName="lock.LockReleaseTest")
public class LockReleaseTest {
    CacheSPI<Object, Object> cache = null;
    UserTransaction tx = null;
    Log log;
    final Fqn NODE1 = Fqn.fromString((String)"/test");
    final Fqn NODE2 = Fqn.fromString((String)"/my/test");
    final String KEY = "key";
    final String VAL1 = "val1";
    final String VAL2 = "val2";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.tx = TransactionSetup.getUserTransaction();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
        TestingUtil.killTransaction(TransactionSetup.getManager());
        if (this.tx != null) {
            try {
                this.tx.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tx = null;
        }
    }

    CacheSPI<Object, Object> createCache(IsolationLevel level) throws Exception {
        CacheSPI c = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        c.getConfiguration().setClusterName("test");
        c.getConfiguration().setStateRetrievalTimeout(10000L);
        c.getConfiguration().setTransactionManagerLookupClass(GenericTransactionManagerLookup.class.getName());
        c.getConfiguration().setLockAcquisitionTimeout(500L);
        c.getConfiguration().setIsolationLevel(level);
        c.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c.create();
        c.start();
        return c;
    }

    public void testReadWithReadUncommitted() throws Exception {
        this.testReadLockRelease(IsolationLevel.READ_UNCOMMITTED);
    }

    public void testWriteWithReadUncommitted() throws Exception {
        this.testWriteLockRelease(IsolationLevel.READ_UNCOMMITTED);
    }

    public void testReadWithReadCommitted() throws Exception {
        this.testReadLockRelease(IsolationLevel.READ_COMMITTED);
    }

    public void testWriteWithReadCommitted() throws Exception {
        this.testWriteLockRelease(IsolationLevel.READ_COMMITTED);
    }

    public void testReadWithRepeatableRead() throws Exception {
        this.testReadLockRelease(IsolationLevel.REPEATABLE_READ);
    }

    public void testWriteWithRepeatableRead() throws Exception {
        this.testWriteLockRelease(IsolationLevel.REPEATABLE_READ);
    }

    public void testReadWithSerialzable() throws Exception {
        this.testReadLockRelease(IsolationLevel.SERIALIZABLE);
    }

    public void testWriteWithSerializable() throws Exception {
        this.testWriteLockRelease(IsolationLevel.SERIALIZABLE);
    }

    public void testGetKeys() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        Set keys = this.cache.getNode(this.NODE1).getKeys();
        System.out.println("keys of " + this.NODE1 + " are " + keys);
        AssertJUnit.assertEquals((String)"getKeys() called outside the TX should have released all locks", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        keys = this.cache.getNode(this.NODE1).getKeys();
        AssertJUnit.assertEquals((String)"we should hold 1 read locks now: ", (int)2, (int)this.cache.getNumberOfLocksHeld());
        keys = this.cache.getNode(this.NODE2).getKeys();
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testGetChildrenNames() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        Set keys = this.cache.getNode(this.NODE2).getChildrenNames();
        System.out.println("keys of " + this.NODE2 + " are " + keys);
        AssertJUnit.assertEquals((String)"getChildrenNames() called outside the TX should have released all locks", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        keys = this.cache.getNode(this.NODE1).getChildrenNames();
        AssertJUnit.assertEquals((String)"we should hold 1 read locks now: ", (int)2, (int)this.cache.getNumberOfLocksHeld());
        keys = this.cache.getNode(this.NODE2).getChildrenNames();
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testPrint() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        System.out.println(this.cache.getNode(this.NODE1));
        AssertJUnit.assertEquals((String)"print() called outside the TX should have released all locks", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        System.out.println(this.cache.getNode(this.NODE1));
        AssertJUnit.assertEquals((String)"we should hold 1 read locks now (for print()): ", (int)2, (int)this.cache.getNumberOfLocksHeld());
        System.out.println(this.cache.getNode(this.NODE2));
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now (for print()): ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private void testReadLockRelease(IsolationLevel level) throws Exception {
        this.cache = this.createCache(level);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get(this.NODE1, (Object)"key"));
        AssertJUnit.assertEquals((Object)"val1", (Object)this.cache.get(this.NODE2, (Object)"key"));
        AssertJUnit.assertEquals((String)"we should hold 3 read locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 read locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private void testWriteLockRelease(IsolationLevel level) throws Exception {
        this.cache = this.createCache(level);
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we ran outside of a TX, locks should have been released: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tx.begin();
        this.cache.put(this.NODE1, (Object)"key", (Object)"val1");
        this.cache.put(this.NODE2, (Object)"key", (Object)"val1");
        AssertJUnit.assertEquals((String)"we should hold 3 write locks now: ", (int)4, (int)this.cache.getNumberOfLocksHeld());
        this.tx.commit();
        AssertJUnit.assertEquals((String)"we should have released all 3 write locks: ", (int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    @Test(invocationCount=10)
    public void testNodeReleaseOnAcquisitionTimeout() throws Exception {
        this.cache = this.createCache(IsolationLevel.REPEATABLE_READ);
        this.cache.put("/a/b", (Object)"key", (Object)"value");
        this.cache.put("/c", (Object)"key", (Object)"value");
        final CountDownLatch rLockAcquired = new CountDownLatch(1);
        final CountDownLatch wlTimeouted = new CountDownLatch(1);
        final CountDownLatch txLocksReleased = new CountDownLatch(1);
        Thread thread = new Thread(){

            public void run() {
                try {
                    LockReleaseTest.this.cache.getTransactionManager().begin();
                    LockReleaseTest.this.cache.get("/a/b", (Object)"key");
                    rLockAcquired.countDown();
                    wlTimeouted.await(60L, TimeUnit.SECONDS);
                    LockReleaseTest.this.cache.getTransactionManager().commit();
                    txLocksReleased.countDown();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        thread.start();
        rLockAcquired.await();
        try {
            this.cache.move("/a/b", "c");
            AssertJUnit.fail((String)"expected timeout here");
        }
        catch (TimeoutException e) {
            wlTimeouted.countDown();
        }
        txLocksReleased.await();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        System.out.println("LockReleaseTest.testNodeReleaseOnAcquisitionTimeout finished!");
    }
}

