/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="lock.PessimisticAcquireAllTest")
public class PessimisticAcquireAllTest {
    CacheSPI<Object, Object> cache = null;
    CacheSPI<Object, Object> cache2;
    final Fqn FQN = Fqn.fromString((String)"/myNode");
    final String KEY = "key";
    final String VALUE = "value";

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache, this.cache2});
        this.cache = null;
        this.cache2 = null;
    }

    public void testAcquireAll() throws Exception {
        Thread owner = Thread.currentThread();
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.put("/a/b/c", null);
        this.cache.put("/1/2/3", null);
        NodeSPI root = this.cache.getRoot();
        NodeLock lock = root.getLock();
        lock.acquireAll((Object)owner, 2000L, LockType.READ);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        lock.acquireAll((Object)owner, 2000L, LockType.WRITE);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testAcquireAllReplicated() throws Exception {
        Thread owner = Thread.currentThread();
        this.cache2 = this.createCache(Configuration.CacheMode.REPL_ASYNC, IsolationLevel.SERIALIZABLE);
        this.cache2.put("/a/b/c", null);
        this.cache2.put("/1/2/3", null);
        this.cache = this.createCache(Configuration.CacheMode.REPL_ASYNC, IsolationLevel.SERIALIZABLE);
        NodeSPI root = this.cache.getRoot();
        NodeLock lock = root.getLock();
        lock.acquireAll((Object)owner, 2000L, LockType.READ);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        lock.acquireAll((Object)owner, 2000L, LockType.WRITE);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private CacheSPI<Object, Object> createCache(Configuration.CacheMode mode, IsolationLevel level) {
        CacheSPI c = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        c.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c.getConfiguration().setCacheMode(mode);
        c.getConfiguration().setIsolationLevel(level);
        c.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c.create();
        c.start();
        return c;
    }
}

