/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="lock.PessimisticLockTest")
public class PessimisticLockTest {
    private Cache<Object, Object> cache;
    private TransactionManager tm;
    private Fqn fqn = Fqn.fromString((String)"/a/b/c");
    private LockManager lockManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.lockManager = TestingUtil.extractLockManager(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    private void assertNoStaleLocks() {
        CacheSPI spi = (CacheSPI)this.cache;
        assert (spi.getNumberOfLocksHeld() == 0) : "Should have no stale locks!";
    }

    public void testPut() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.assertNoStaleLocks();
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k2", (Object)"v2");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(this.fqn);
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n, LockType.READ));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n, LockType.WRITE));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n.getParentDirect(), LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n.getParentDirect(), LockType.WRITE));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n.getParentDirect().getParentDirect(), LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n.getParentDirect().getParentDirect(), LockType.WRITE));
        this.tm.commit();
        this.assertNoStaleLocks();
    }

    public void testGet() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.assertNoStaleLocks();
        this.tm.begin();
        this.cache.get(this.fqn, (Object)"k2");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(this.fqn);
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n, LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n, LockType.WRITE));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n.getParentDirect(), LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n.getParentDirect(), LockType.WRITE));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n.getParentDirect().getParentDirect(), LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n.getParentDirect().getParentDirect(), LockType.WRITE));
        this.tm.commit();
        this.assertNoStaleLocks();
    }

    public void testRemove() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.assertNoStaleLocks();
        this.tm.begin();
        this.cache.remove(this.fqn, (Object)"k2");
        NodeSPI n = (NodeSPI)this.cache.getRoot().getChild(this.fqn);
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n, LockType.READ));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n, LockType.WRITE));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n.getParentDirect(), LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n.getParentDirect(), LockType.WRITE));
        AssertJUnit.assertTrue((boolean)this.lockManager.isLocked(n.getParentDirect().getParentDirect(), LockType.READ));
        AssertJUnit.assertFalse((boolean)this.lockManager.isLocked(n.getParentDirect().getParentDirect(), LockType.WRITE));
        this.tm.commit();
        this.assertNoStaleLocks();
    }
}

