/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false, testName="lock.ReentrantWriterPreference2Readers1WriterLockTest")
public class ReentrantWriterPreference2Readers1WriterLockTest {
    ReentrantReadWriteLock lock;
    ReentrantReadWriteLock.ReadLock rl;
    ReentrantReadWriteLock.WriteLock wl;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.lock = new ReentrantReadWriteLock();
        this.rl = this.lock.readLock();
        this.wl = this.lock.writeLock();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.lock = null;
    }

    private void log(String msg) {
        System.out.println(System.currentTimeMillis() + "  " + Thread.currentThread() + " [" + Thread.currentThread().getName() + "]: " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSimpleUpgradeFromReadLockToWriteLock() {
        try {
            try {
                this.rl.lock();
                int readers = this.lock.getReadLockCount();
                AssertJUnit.assertEquals((int)1, (int)readers);
                boolean wl_acquired = this.wl.tryLock(500L, TimeUnit.MILLISECONDS);
                if (!wl_acquired) {
                    AssertJUnit.fail((String)"write lock could not be acquired");
                    Object var5_4 = null;
                    this.rl.unlock();
                    if (this.lock.getWriteHoldCount() <= 0) return;
                    this.wl.unlock();
                    return;
                }
                readers = this.lock.getReadLockCount();
                AssertJUnit.assertEquals((int)1, (int)readers);
                int writers = this.lock.getWriteHoldCount();
                AssertJUnit.assertEquals((int)1, (int)writers);
            }
            catch (InterruptedException interruptedException) {
                Object var5_6 = null;
                this.rl.unlock();
                if (this.lock.getWriteHoldCount() <= 0) return;
                this.wl.unlock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.rl.unlock();
            if (this.lock.getWriteHoldCount() <= 0) throw throwable;
            this.wl.unlock();
            throw throwable;
        }
        Object var5_5 = null;
        this.rl.unlock();
        if (this.lock.getWriteHoldCount() <= 0) return;
        this.wl.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2ReadersAnd1Writer() throws InterruptedException {
        Upgrader upgrader = new Upgrader("Upgrader");
        Reader reader = new Reader("Reader");
        reader.start();
        ReentrantWriterPreference2Readers1WriterLockTest.sleepThread(500L);
        int readers = this.lock.getReadLockCount();
        AssertJUnit.assertEquals((int)1, (int)readers);
        upgrader.start();
        ReentrantWriterPreference2Readers1WriterLockTest.sleepThread(500L);
        readers = this.lock.getReadLockCount();
        AssertJUnit.assertEquals((int)2, (int)readers);
        Thread thread = upgrader;
        synchronized (thread) {
            upgrader.notify();
        }
        ReentrantWriterPreference2Readers1WriterLockTest.sleepThread(500L);
        readers = this.lock.getReadLockCount();
        AssertJUnit.assertEquals((int)2, (int)readers);
        int writers = this.lock.getWriteHoldCount();
        AssertJUnit.assertEquals((int)0, (int)writers);
        thread = reader;
        synchronized (thread) {
            reader.notify();
        }
        reader.join();
        readers = this.lock.getReadLockCount();
        AssertJUnit.assertEquals((int)1, (int)readers);
        writers = this.lock.getWriteHoldCount();
        AssertJUnit.assertEquals((int)1, (int)writers);
        thread = upgrader;
        synchronized (thread) {
            upgrader.notify();
        }
        ReentrantWriterPreference2Readers1WriterLockTest.sleepThread(500L);
        readers = this.lock.getReadLockCount();
        AssertJUnit.assertEquals((int)0, (int)readers);
        writers = this.lock.getWriteHoldCount();
        AssertJUnit.assertEquals((int)0, (int)writers);
        upgrader.join(3000L);
        AssertJUnit.assertTrue((String)"Known failure. See JBCACHE-461; This is due to a potential bug in ReentrantWriterPreferenceReadWriteLock !", (boolean)upgrader.wasUpgradeSuccessful());
    }

    static void sleepThread(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class Upgrader
    extends Thread {
        boolean upgradeSuccessful;

        public Upgrader(String name) {
            super(name);
            this.upgradeSuccessful = false;
        }

        public boolean wasUpgradeSuccessful() {
            return this.upgradeSuccessful;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("acquiring RL");
                    ReentrantWriterPreference2Readers1WriterLockTest.this.rl.lock();
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("acquired RL");
                    Upgrader upgrader = this;
                    synchronized (upgrader) {
                        this.wait();
                    }
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("attempting to acquire WL");
                    ReentrantWriterPreference2Readers1WriterLockTest.this.wl.lock();
                    this.upgradeSuccessful = true;
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("acquired WL");
                    upgrader = this;
                    synchronized (upgrader) {
                        this.wait();
                    }
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("releasing WL");
                    ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("released WL");
                }
                catch (InterruptedException interruptedException) {
                    Object var5_6 = null;
                    ReentrantWriterPreference2Readers1WriterLockTest.this.wl.unlock();
                    ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
                }
                Object var5_5 = null;
                ReentrantWriterPreference2Readers1WriterLockTest.this.wl.unlock();
                ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ReentrantWriterPreference2Readers1WriterLockTest.this.wl.unlock();
                ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
                throw throwable;
            }
        }
    }

    private class Reader
    extends Thread {
        public Reader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("acquiring RL");
                    ReentrantWriterPreference2Readers1WriterLockTest.this.rl.lock();
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("acquired RL");
                    Reader reader = this;
                    synchronized (reader) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Object var4_4 = null;
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("releasing RL");
                    ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
                    ReentrantWriterPreference2Readers1WriterLockTest.this.log("released RL");
                    return;
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ReentrantWriterPreference2Readers1WriterLockTest.this.log("releasing RL");
                ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
                ReentrantWriterPreference2Readers1WriterLockTest.this.log("released RL");
                throw throwable;
            }
            ReentrantWriterPreference2Readers1WriterLockTest.this.log("releasing RL");
            ReentrantWriterPreference2Readers1WriterLockTest.this.rl.unlock();
            ReentrantWriterPreference2Readers1WriterLockTest.this.log("released RL");
        }
    }
}

