/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="lock.ReentrantWriterPreferenceReadWriteLockTest")
public class ReentrantWriterPreferenceReadWriteLockTest {
    ReentrantReadWriteLock lock;
    Lock rl;
    Lock wl;
    Exception thread_ex = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.lock = new ReentrantReadWriteLock();
        this.rl = this.lock.readLock();
        this.wl = this.lock.writeLock();
        this.thread_ex = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.lock = null;
        if (this.thread_ex != null) {
            throw this.thread_ex;
        }
    }

    public void testMultipleReadLockAcquisitions() throws InterruptedException {
        this.rl.lock();
        this.rl.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testInterruptedLockAcquisition() {
        block8: {
            Thread.currentThread().interrupt();
            this.rl.lockInterruptibly();
            AssertJUnit.fail((String)"thread should be in interrupted status");
            Object var3_1 = null;
            try {
                this.rl.unlock();
                AssertJUnit.fail((String)"unlock() should throw an IllegalStateException");
            }
            catch (IllegalMonitorStateException illegalStateEx) {
                AssertJUnit.assertTrue((boolean)true);
            }
            break block8;
            {
                catch (InterruptedException interruptedException) {
                    Object var3_2 = null;
                    try {
                        this.rl.unlock();
                        AssertJUnit.fail((String)"unlock() should throw an IllegalStateException");
                    }
                    catch (IllegalMonitorStateException illegalStateEx) {
                        AssertJUnit.assertTrue((boolean)true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.rl.unlock();
                    AssertJUnit.fail((String)"unlock() should throw an IllegalStateException");
                }
                catch (IllegalMonitorStateException illegalStateEx) {
                    AssertJUnit.assertTrue((boolean)true);
                }
                throw throwable;
            }
        }
    }

    public void testMultipleWriteLockAcquisitions() throws InterruptedException {
        this.wl.lock();
        this.wl.lock();
    }

    public void testMultipleReadLockReleases() throws InterruptedException {
        this.rl.lock();
        this.rl.unlock();
        try {
            this.rl.unlock();
            AssertJUnit.fail((String)"we should not get here, cannot lock RL once but unlock twice");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testMultipleWriteLockReleases() throws InterruptedException {
        this.wl.lock();
        this.wl.unlock();
        try {
            this.wl.unlock();
            AssertJUnit.fail((String)"expected");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testAcquireWriteLockAfterReadLock() throws InterruptedException {
        this.rl.lock();
        this.rl.unlock();
        this.wl.lock();
    }

    public void testAcquiringReadLockedLockWithRead() throws InterruptedException {
        new Thread(){

            public void run() {
                try {
                    ReentrantWriterPreferenceReadWriteLockTest.this.rl.lockInterruptibly();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        TestingUtil.sleepThread(500L);
        boolean flag = this.rl.tryLock(3000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertTrue((boolean)flag);
        flag = this.wl.tryLock(3000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertFalse((boolean)flag);
    }

    public void testAcquiringReadLockedLock() throws InterruptedException {
        new Thread(){

            public void run() {
                try {
                    ReentrantWriterPreferenceReadWriteLockTest.this.rl.lockInterruptibly();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        TestingUtil.sleepThread(500L);
        boolean flag = this.wl.tryLock(3000L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertFalse((boolean)flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteThenReadByDifferentTx() throws InterruptedException {
        Writer writer = new Writer("Writer");
        Reader reader = new Reader("Reader");
        writer.start();
        TestingUtil.sleepThread(500L);
        reader.start();
        TestingUtil.sleepThread(1000L);
        Thread thread = writer;
        synchronized (thread) {
            ReentrantWriterPreferenceReadWriteLockTest.log("terminating Writer");
            writer.notify();
        }
        TestingUtil.sleepThread(500L);
        thread = reader;
        synchronized (thread) {
            reader.notify();
        }
        writer.join();
        reader.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadThenWriteByDifferentTx() throws InterruptedException {
        Writer writer = new Writer("Writer");
        Reader reader = new Reader("Reader");
        reader.start();
        TestingUtil.sleepThread(500L);
        writer.start();
        TestingUtil.sleepThread(1000L);
        Thread thread = reader;
        synchronized (thread) {
            ReentrantWriterPreferenceReadWriteLockTest.log("terminating Reader");
            reader.notify();
        }
        TestingUtil.sleepThread(500L);
        thread = writer;
        synchronized (thread) {
            writer.notify();
        }
        writer.join();
        reader.join();
    }

    private static void log(String msg) {
        System.out.println(System.currentTimeMillis() + "  " + Thread.currentThread() + " [" + Thread.currentThread().getName() + "]: " + msg);
    }

    class Upgrader
    extends Thread {
        boolean upgradeSuccessful;

        public Upgrader(String name) {
            super(name);
            this.upgradeSuccessful = false;
        }

        public boolean wasUpgradeSuccessful() {
            return this.upgradeSuccessful;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReentrantWriterPreferenceReadWriteLockTest.log("acquiring RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.rl.lock();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired RL");
                Upgrader upgrader = this;
                synchronized (upgrader) {
                    this.wait();
                }
                ReentrantWriterPreferenceReadWriteLockTest.log("attempting to lock WL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.lock();
                this.upgradeSuccessful = true;
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired WL");
                ReentrantWriterPreferenceReadWriteLockTest.log("releasing WL/RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.unlock();
                ReentrantWriterPreferenceReadWriteLockTest.log("released WL/RL");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class Writer
    extends Thread {
        public Writer(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReentrantWriterPreferenceReadWriteLockTest.log("acquiring WL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.lock();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired WL");
                Writer writer = this;
                synchronized (writer) {
                    this.wait();
                }
                ReentrantWriterPreferenceReadWriteLockTest.log("releasing WL");
                ReentrantWriterPreferenceReadWriteLockTest.this.wl.unlock();
                ReentrantWriterPreferenceReadWriteLockTest.log("released WL");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class Reader
    extends Thread {
        public Reader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ReentrantWriterPreferenceReadWriteLockTest.log("acquiring RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.rl.lock();
                ReentrantWriterPreferenceReadWriteLockTest.log("acquired RL");
                Reader reader = this;
                synchronized (reader) {
                    this.wait();
                }
                ReentrantWriterPreferenceReadWriteLockTest.log("releasing RL");
                ReentrantWriterPreferenceReadWriteLockTest.this.rl.unlock();
                ReentrantWriterPreferenceReadWriteLockTest.log("released RL");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

