/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.marshall.AbstractVersionAwareMarshallerTest;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="marshall.ActiveInactiveTest")
public class ActiveInactiveTest
extends AbstractVersionAwareMarshallerTest {
    RegionManager rman;
    CacheSPI cache;
    Configuration c;
    Fqn A = Fqn.fromString((String)"/a");
    Fqn I = Fqn.fromString((String)"/i");
    Fqn A_B = Fqn.fromRelativeElements((Fqn)this.A, (Object[])new String[]{"b"});

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.c = this.cache.getConfiguration();
        this.c.setUseRegionBasedMarshalling(true);
        this.c.setFetchInMemoryState(false);
        this.cache.start();
        this.cr = TestingUtil.extractComponentRegistry((Cache)this.cache);
        this.rman = (RegionManager)TestingUtil.extractComponentRegistry((Cache)this.cache).getComponent(RegionManager.class);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testDefaultActive() throws Exception {
        this.rman.setDefaultInactive(false);
        AssertJUnit.assertFalse((String)"Root is not active", (boolean)this.rman.isInactive(Fqn.ROOT));
        this.rman.deactivate(this.A);
        AssertJUnit.assertFalse((String)"Root is not active after inactivating subtree", (boolean)this.rman.isInactive(Fqn.ROOT));
        this.rman.activate(this.A);
        AssertJUnit.assertFalse((String)"Root is not active after activating subtree", (boolean)this.rman.isInactive(Fqn.ROOT));
        this.rman.activate(this.A_B);
        this.rman.deactivate(Fqn.ROOT);
        AssertJUnit.assertTrue((String)"Root is active", (boolean)this.rman.isInactive(Fqn.ROOT));
    }

    public void testDefaultInactive() throws Exception {
        this.rman.setDefaultInactive(true);
        AssertJUnit.assertTrue((String)"Root is not inactive", (boolean)this.rman.isInactive(Fqn.ROOT));
        this.rman.activate(this.A);
        AssertJUnit.assertTrue((String)"Root is not inactive after activating subtree", (boolean)this.rman.isInactive(Fqn.ROOT));
        this.rman.deactivate(this.A);
        AssertJUnit.assertTrue((String)"Root is not inactive after inactivating subtree", (boolean)this.rman.isInactive(Fqn.ROOT));
        this.rman.deactivate(this.A_B);
        this.rman.activate(Fqn.ROOT);
        AssertJUnit.assertFalse((String)"Root is not active", (boolean)this.rman.isInactive(Fqn.ROOT));
    }

    public void testActivate() throws Exception {
        this.rman.setDefaultInactive(false);
        this.rman.activate(this.A);
        AssertJUnit.assertFalse((String)"/a is not active after activating", (boolean)this.rman.isInactive(this.A));
        this.rman.deactivate(this.A);
        this.rman.activate(this.A);
        AssertJUnit.assertFalse((String)"/a is not active after reactivating", (boolean)this.rman.isInactive(this.A));
        this.rman.reset();
        this.rman.setDefaultInactive(true);
        this.rman.activate(this.I);
        AssertJUnit.assertFalse((String)"/i is not active after activating", (boolean)this.rman.isInactive(this.I));
        AssertJUnit.assertFalse((String)"/i/k is not active after activating /i", (boolean)this.rman.isInactive(Fqn.fromString((String)"/i/k")));
        this.rman.deactivate(this.I);
        this.rman.activate(this.I);
        AssertJUnit.assertFalse((String)"/i is not active after reactivating", (boolean)this.rman.isInactive(this.I));
    }

    public void testInactivate() throws Exception {
        this.rman.setDefaultInactive(true);
        this.rman.deactivate(this.I);
        AssertJUnit.assertTrue((String)"/i is not inactive after inactivating", (boolean)this.rman.isInactive(this.I));
        this.rman.activate(this.I);
        this.rman.deactivate(this.I);
        AssertJUnit.assertTrue((String)"/i is not inactive after re-inactivating", (boolean)this.rman.isInactive(this.I));
        this.rman.reset();
        this.rman.setDefaultInactive(false);
        this.rman.deactivate(this.A);
        AssertJUnit.assertTrue((String)"/a is not inactive after inactivating", (boolean)this.rman.isInactive(this.A));
        AssertJUnit.assertTrue((String)"/a/b is not inactive after inactivating /a", (boolean)this.rman.isInactive(this.A_B));
        this.rman.activate(this.A);
        this.rman.deactivate(this.A);
        AssertJUnit.assertTrue((String)"/a is not inactive after re-inactivating", (boolean)this.rman.isInactive(this.A));
    }

    public void testObjectFromByteBuffer() throws Exception {
        PutKeyValueCommand put = new PutKeyValueCommand(null, this.A_B, (Object)"name", (Object)"Joe");
        ReplicateCommand replicate = new ReplicateCommand((ReplicableCommand)put);
        this.rman.setDefaultInactive(true);
        Region region_A = this.rman.getRegion(this.A, true);
        region_A.registerContextClassLoader(this.getClass().getClassLoader());
        AssertJUnit.assertFalse((String)"New regions created should be inactive by default", (boolean)region_A.isActive());
        this.cache.stop();
        this.c.setUseRegionBasedMarshalling(true);
        this.c.setInactiveOnStartup(true);
        VersionAwareMarshaller testee = this.createVAMandRestartCache(this.rman);
        byte[] callBytes = testee.objectToByteBuffer((Object)replicate);
        try {
            testee.objectFromByteBuffer(callBytes);
            AssertJUnit.fail((String)"Expected to fail since region is inactive");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.rman.activate(this.A);
        AssertJUnit.assertTrue((boolean)this.rman.hasRegion(this.A, Region.Type.MARSHALLING));
        ReplicableCommand result = (ReplicableCommand)testee.objectFromByteBuffer(callBytes);
        AssertJUnit.assertEquals((String)"Did not get replicate method when passing call for active node", ReplicateCommand.class, result.getClass());
    }
}

