/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.Global;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false, sequential=true, testName="marshall.RedeploymentEmulationTest")
public class RedeploymentEmulationTest {
    private Cache<Object, Object> cache;
    private static final String INSTANCE_LIBRARY = "jgroups-all.jar";
    private static final String INSTANCE_CLASS_NAME = "org.jgroups.Global";
    private static final String USER_DIR = ".";
    private static final String FILE_SEPARATOR = File.separator;
    private static final String LIB_DIR_NAME = "lib";
    private static final String LIB_DIR = "." + FILE_SEPARATOR + "lib" + FILE_SEPARATOR;
    private static final String LIB_DIR_SP = System.getProperty("lib.dir");
    private static final Log log = LogFactory.getLog(RedeploymentEmulationTest.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setUseRegionBasedMarshalling(true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        log.info((Object)"**** IN TEAR DOWN ***");
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testClassCastException() throws Exception {
        this.cache.start();
        URLClassLoader ucl1 = this.createOrphanClassLoader();
        Thread.currentThread().setContextClassLoader(ucl1);
        Class<?> clazz1 = ucl1.loadClass(INSTANCE_CLASS_NAME);
        this.cache.put(RedeploymentEmulationTest.fqn("/a"), (Object)"key", clazz1.newInstance());
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        try {
            Global object = (Global)this.cache.get(RedeploymentEmulationTest.fqn("/a"), (Object)"key");
            AssertJUnit.fail((String)"Should have produced a ClassCastException");
        }
        catch (ClassCastException cce) {
            System.out.println("Expecting: org.jgroups.Global");
            System.out.println("Got: " + cce.getMessage());
            AssertJUnit.assertTrue((boolean)cce.getMessage().startsWith(INSTANCE_CLASS_NAME));
        }
    }

    public void testRegisterUnregister() throws Exception {
        this.cache.start();
        URLClassLoader ucl1 = this.createOrphanClassLoader();
        Thread.currentThread().setContextClassLoader(ucl1);
        Region region = this.cache.getRegion(RedeploymentEmulationTest.fqn("/"), true);
        region.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
        region.activate();
        Class<?> clazz1 = ucl1.loadClass(INSTANCE_CLASS_NAME);
        this.cache.put(RedeploymentEmulationTest.fqn("/a"), (Object)"key", clazz1.newInstance());
        region.deactivate();
        region.unregisterContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        region.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            Global object = (Global)this.cache.get(RedeploymentEmulationTest.fqn("/a"), (Object)"key");
            AssertJUnit.assertNull((Object)object);
        }
        catch (ClassCastException cce) {
            AssertJUnit.fail((String)"Should not have produced a ClassCastException");
        }
        region.deactivate();
        region.unregisterContextClassLoader();
    }

    private URLClassLoader createOrphanClassLoader() throws MalformedURLException {
        File f = LIB_DIR_SP == null ? new File(USER_DIR + FILE_SEPARATOR + LIB_DIR + FILE_SEPARATOR) : new File(LIB_DIR_SP);
        URL context = f.toURL();
        URL jar = new URL(context, INSTANCE_LIBRARY);
        URLClassLoader ucl1 = new URLClassLoader(new URL[]{jar}, null);
        return ucl1;
    }

    private static Fqn fqn(String fqn) {
        return Fqn.fromString((String)fqn);
    }
}

