/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.Arrays;
import java.util.Random;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.SimpleArrayReplTest")
public class SimpleArrayReplTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArrayRepl() throws CloneNotSupportedException {
        int streamsize = 11000;
        byte[] b = new byte[streamsize];
        new Random().nextBytes(b);
        Cache cache1 = null;
        Cache cache2 = null;
        try {
            Configuration c = new Configuration();
            c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
            c.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
            cache1 = new UnitTestCacheFactory().createCache(c.clone());
            cache2 = new UnitTestCacheFactory().createCache(c.clone());
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            cache1.put(Fqn.fromString((String)"/a"), (Object)"test", (Object)b);
            byte[] bytesBack = (byte[])cache2.get(Fqn.fromString((String)"/a"), (Object)"test");
            assert (Arrays.equals(b, bytesBack));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            TestingUtil.killCaches(cache1, cache2);
            throw throwable;
        }
        TestingUtil.killCaches(cache1, cache2);
    }
}

