/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.marshall.FooClassLoader;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.marshall.data.Address;
import org.jboss.cache.marshall.data.Person;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"}, testName="marshall.SyncReplTest")
public class SyncReplTest
extends RegionBasedMarshallingTestBase {
    protected ThreadLocal<SyncReplTestTL> threadLocal = new ThreadLocal();
    private Fqn aop = Fqn.fromString((String)"/aop");
    protected boolean useMarshalledValues = false;

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        SyncReplTestTL srtl = new SyncReplTestTL();
        this.threadLocal.set(srtl);
        this.log("creating cache1");
        srtl.cache1 = this.createCache("TestCache");
        this.log("creating cache2");
        srtl.cache2 = this.createCache("TestCache");
        srtl.addr_ = new Address();
        srtl.addr_.setCity("San Jose");
        srtl.ben_ = new Person();
        srtl.ben_.setName("Ben");
        srtl.ben_.setAddress(srtl.addr_);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{srtl.cache1, srtl.cache2}, 60000L);
    }

    private CacheSPI<Object, Object> createCache(String name) {
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        cache.getConfiguration().setClusterName(name + "-" + Thread.currentThread().getName());
        cache.getConfiguration().setUseLazyDeserialization(this.useMarshalledValues);
        cache.getConfiguration().setUseRegionBasedMarshalling(!this.useMarshalledValues);
        cache.create();
        cache.start();
        return cache;
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        cache1.removeNode(Fqn.ROOT);
        if (cache1 != null) {
            this.log("stopping cache1");
            cache1.stop();
        }
        if (cache2 != null) {
            this.log("stopping cache2");
            cache2.stop();
        }
        super.tearDown();
        this.threadLocal.set(null);
    }

    public void testPlainPut() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        cache1.put(this.aop, (Object)"person", (Object)srtl.ben_);
        Person ben2 = (Person)cache2.get(this.aop, (Object)"person");
        AssertJUnit.assertNotNull((String)"Person from 2nd cache should not be null ", (Object)ben2);
        AssertJUnit.assertEquals((String)srtl.ben_.toString(), (String)ben2.toString());
    }

    public void testCCE() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader c1 = this.getClassLoader();
        ClassLoader c2 = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(c1);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(c2);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(c1);
        }
        cache1.put(this.aop, (Object)"person", (Object)srtl.ben_);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(this.getFailingClassLoader());
        }
        try {
            if (this.useMarshalledValues) {
                Thread.currentThread().setContextClassLoader(c2);
            }
            Person person = (Person)cache2.get(this.aop, (Object)"person");
        }
        catch (ClassCastException ex) {
            return;
        }
        AssertJUnit.fail((String)"Should have thrown an exception");
    }

    public void testPut() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        cache1.put(this.aop, (Object)"person", (Object)srtl.ben_);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        Object ben2 = cache2.get(this.aop, (Object)"person");
        AssertJUnit.assertEquals((String)srtl.ben_.toString(), (String)ben2.toString());
    }

    public void testCLSet() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        cache1.put(this.aop, (Object)"person", (Object)srtl.ben_);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        Object ben2 = cache2.get(this.aop, (Object)"person");
        AssertJUnit.assertEquals((String)srtl.ben_.toString(), (String)ben2.toString());
        Class<?> claz = clb.loadClass("org.jboss.cache.marshall.data.Address");
        Object add = claz.newInstance();
        Method setValue = claz.getMethod("setCity", String.class);
        setValue.invoke(add, "Sunnyvale");
        Class<?> clasz1 = clb.loadClass("org.jboss.cache.marshall.data.Person");
        setValue = clasz1.getMethod("setAddress", claz);
        setValue.invoke(ben2, add);
    }

    public void testCLSet2() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        cache1.put(this.aop, (Object)"person", (Object)srtl.ben_);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        Object ben2 = cache2.get(this.aop, (Object)"person");
        AssertJUnit.assertEquals((String)srtl.ben_.toString(), (String)ben2.toString());
        Class<?> claz = clb.loadClass("org.jboss.cache.marshall.data.Address");
        Object add = claz.newInstance();
        Method setValue = claz.getMethod("setCity", String.class);
        setValue.invoke(add, "Sunnyvale");
        Class<?> clasz1 = clb.loadClass("org.jboss.cache.marshall.data.Person");
        setValue = clasz1.getMethod("setAddress", claz);
        setValue.invoke(ben2, add);
        cache2.put(this.aop, (Object)"person", ben2);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        Object ben3 = cache1.get(this.aop, (Object)"person");
        AssertJUnit.assertEquals((String)ben2.toString(), (String)ben3.toString());
    }

    public void testPuts() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        Object scopedBen1 = this.getPersonFromClassloader(cla);
        Object scopedBen2 = this.getPersonFromClassloader(clb);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        cache1.put(Fqn.fromString((String)"/aop/1"), (Object)"person", (Object)srtl.ben_);
        cache1.put(Fqn.fromString((String)"/aop/2"), (Object)"person", scopedBen1);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        Object ben2 = cache2.get(Fqn.fromString((String)"/aop/1"), (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertEquals((String)srtl.ben_.toString(), (String)ben2.toString());
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        ben2 = cache2.get(Fqn.fromString((String)"/aop/2"), (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertFalse((String)"cache2 deserialized with scoped classloader", (boolean)(ben2 instanceof Person));
        AssertJUnit.assertFalse((String)"cache2 deserialized with cache2 classloader", (boolean)scopedBen1.equals(ben2));
        AssertJUnit.assertEquals((String)"scopedBen deserialized properly", (Object)scopedBen2, (Object)ben2);
    }

    public void testMethodCall() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        cache1.put(Fqn.fromString((String)"/aop/1"), (Object)"person", (Object)srtl.ben_);
        cache1.remove(Fqn.fromString((String)"/aop/1"), (Object)"person");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        cache1.put(Fqn.fromString((String)"/aop/2"), map);
        cache1.removeNode(Fqn.fromString((String)"/aop/2"));
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
    }

    public void testTxMethodCall() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        TransactionManager tm = this.beginTransaction();
        cache1.put(Fqn.fromString((String)"/aop/1"), (Object)"person", (Object)srtl.ben_);
        cache1.remove(Fqn.fromString((String)"/aop/1"), (Object)"person");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        cache1.put(Fqn.fromString((String)"/aop/2"), map);
        cache1.removeNode(Fqn.fromString((String)"/aop/2"));
        tm.commit();
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
    }

    public void testTxCLSet2() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        ClassLoader cla = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
        }
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        TransactionManager tm = this.beginTransaction();
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        cache1.put(this.aop, (Object)"person", (Object)srtl.ben_);
        tm.commit();
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        Object ben2 = cache2.get(this.aop, (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertEquals((String)srtl.ben_.toString(), (String)ben2.toString());
        Class<?> claz = clb.loadClass("org.jboss.cache.marshall.data.Address");
        Object add = claz.newInstance();
        Method setValue = claz.getMethod("setCity", String.class);
        setValue.invoke(add, "Sunnyvale");
        Class<?> clasz1 = clb.loadClass("org.jboss.cache.marshall.data.Person");
        setValue = clasz1.getMethod("setAddress", claz);
        setValue.invoke(ben2, add);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        cache2.put(this.aop, (Object)"person", ben2);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        Object ben3 = cache1.get(this.aop, (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertEquals((String)ben2.toString(), (String)ben3.toString());
    }

    public void testStateTransfer() throws Exception {
    }

    public void testCustomFqn() throws Exception {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        CacheSPI<Object, Object> cache2 = srtl.cache2;
        FooClassLoader cl1 = new FooClassLoader(Thread.currentThread().getContextClassLoader());
        Region r1 = cache1.getRegion(this.aop, false) == null ? cache1.getRegion(this.aop, true) : cache1.getRegion(this.aop, false);
        r1.registerContextClassLoader((ClassLoader)cl1);
        FooClassLoader cl2 = new FooClassLoader(Thread.currentThread().getContextClassLoader());
        Region r2 = cache2.getRegion(this.aop, false) == null ? cache2.getRegion(this.aop, true) : cache2.getRegion(this.aop, false);
        r2.registerContextClassLoader((ClassLoader)cl2);
        Class clazz = cl1.loadFoo();
        Object custom1 = clazz.newInstance();
        clazz = cl2.loadFoo();
        Object custom2 = clazz.newInstance();
        cache1.put(Fqn.fromElements((Object[])new Object[]{"aop", custom1}), (Object)"key", (Object)"value");
        try {
            Object val = cache2.get(Fqn.fromElements((Object[])new Object[]{"aop", custom2}), (Object)"key");
            AssertJUnit.assertEquals((Object)"value", (Object)val);
        }
        catch (Exception ex) {
            AssertJUnit.fail((String)("Test fails with exception " + ex));
        }
    }

    private TransactionManager beginTransaction() throws SystemException, NotSupportedException {
        SyncReplTestTL srtl = this.threadLocal.get();
        CacheSPI<Object, Object> cache1 = srtl.cache1;
        TransactionManager mgr = cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }

    protected Object getPersonFromClassloader(ClassLoader cl) throws Exception {
        Class<?> clazz = cl.loadClass("org.jboss.cache.marshall.data.Person");
        return clazz.newInstance();
    }

    private void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }

    protected class SyncReplTestTL {
        CacheSPI<Object, Object> cache1;
        CacheSPI<Object, Object> cache2;
        String props = null;
        Person ben_;
        Address addr_;
        Throwable ex_;

        protected SyncReplTestTL() {
        }
    }
}

