/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import org.jboss.cache.marshall.UnmarshalledReferences;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.UnmarshalledReferencesTest")
public class UnmarshalledReferencesTest {
    public void testSimpleGetPut() {
        int i;
        UnmarshalledReferences refs = new UnmarshalledReferences();
        for (i = 0; i < 100; ++i) {
            refs.putReferencedObject(i, (Object)String.valueOf(i));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)refs.getReferencedObject(i), (Object)String.valueOf(i));
        }
    }

    public void testPutWithGap() {
        UnmarshalledReferences refs = new UnmarshalledReferences();
        refs.putReferencedObject(0, (Object)"0");
        refs.putReferencedObject(2, (Object)"2");
        Assert.assertEquals((Object)refs.getReferencedObject(0), (Object)"0");
        Assert.assertNull((Object)refs.getReferencedObject(1));
        Assert.assertEquals((Object)refs.getReferencedObject(2), (Object)"2");
    }

    public void testPutBefore() {
        UnmarshalledReferences refs = new UnmarshalledReferences();
        refs.putReferencedObject(2, (Object)"2");
        refs.putReferencedObject(3, (Object)"3");
        refs.putReferencedObject(1, (Object)"1");
        Assert.assertNull((Object)refs.getReferencedObject(0));
        Assert.assertEquals((Object)"1", (Object)refs.getReferencedObject(1));
        Assert.assertEquals((Object)"2", (Object)refs.getReferencedObject(2));
        Assert.assertEquals((Object)"3", (Object)refs.getReferencedObject(3));
    }
}

