/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction", "optimistic"}, testName="optimistic.AsyncFullStackInterceptorTest")
public class AsyncFullStackInterceptorTest
extends AbstractOptimisticTestCase {
    private int groupIncreaser = 0;

    public void testSingleInstanceRollback() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createAsyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((boolean)false, (boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)cache.getNode("/one"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceDuplicateCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createAsyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode(Fqn.fromString((String)"/one"))));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode(Fqn.fromString((String)"/one/two"))));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one/two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testValidationFailCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createAsyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.suspend();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        cache.put("/one/two", (Object)"key1", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.resume(tx);
        try {
            mgr.commit();
            assert (false) : "Expecting an exception";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void test2InstanceCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createAsyncReplicatedCache();
        CacheSPI<Object, Object> cache2 = this.createAsyncReplicatedCache();
        ReplicationListener replListener2 = new ReplicationListener((Cache)cache2);
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        LockManager lockManager2 = TestingUtil.extractLockManager(cache2);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        replListener2.expectAny();
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        replListener2.waitForReplicationToOccur(1000L);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void test2InstanceRemove() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createAsyncReplicatedCache();
        CacheSPI<Object, Object> cache2 = this.createAsyncReplicatedCache();
        ReplicationListener replListener2 = new ReplicationListener((Cache)cache2);
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        LockManager lockManager2 = TestingUtil.extractLockManager(cache2);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        replListener2.expect(PutKeyValueCommand.class, CommitCommand.class);
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        replListener2.waitForReplicationToOccur(1000L);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        replListener2.expect(RemoveNodeCommand.class);
        replListener2.expect(CommitCommand.class);
        cache.removeNode("/one/two");
        replListener2.waitForReplicationToOccur(1000L);
        AssertJUnit.assertEquals((boolean)false, (boolean)cache.exists("/one/two"));
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two", (Object)"key1"));
        AssertJUnit.assertEquals((boolean)false, (boolean)cache2.exists("/one/two"));
        AssertJUnit.assertEquals(null, (Object)cache2.get("/one/two", (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testValidationFailCommit2Instances() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createAsyncReplicatedCache();
        ReplicationListener replListener = new ReplicationListener((Cache)cache);
        CacheSPI<Object, Object> cache2 = this.createAsyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.suspend();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        cache2.put("/one/two", (Object)"key1", (Object)pojo2);
        mgr.commit();
        TestingUtil.sleepThread(1000L);
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.resume(tx);
        try {
            mgr.commit();
            assert (false) : "Expecting an exception";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((int)0, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    protected CacheSPI<Object, Object> createAsyncReplicatedCache() throws Exception {
        return this.createReplicatedCache("temp" + this.groupIncreaser, Configuration.CacheMode.REPL_ASYNC);
    }
}

