/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true, testName="optimistic.CacheTest")
public class CacheTest
extends AbstractOptimisticTestCase {
    Log log = LogFactory.getLog(CacheTest.class);
    private CacheSPI<Object, Object> c;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.c = this.createCache();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        if (this.c != null) {
            this.destroyCache((Cache<Object, Object>)this.c);
        }
        this.c = null;
    }

    public void testRoot() {
        NodeSPI node = this.c.getRoot();
        assert (((NodeInvocationDelegate)node).getDelegationTarget() instanceof VersionedNode);
    }

    public void testExplicitTxFailure() throws Exception {
        TransactionManager mgr = this.c.getTransactionManager();
        try {
            mgr.begin();
            this.c.put("/a", (Object)"k", (Object)"v");
            Transaction t = mgr.suspend();
            this.c.put("/a", (Object)"k2", (Object)"v2");
            mgr.resume(t);
            mgr.commit();
            AssertJUnit.assertTrue((String)"Expecting a rollback exception!", (boolean)false);
        }
        catch (RollbackException re) {
            AssertJUnit.assertTrue((String)"Expecting a rollback exception!", (boolean)true);
        }
    }

    public void testImplicitTxFailure() throws Exception {
        int i;
        int numThreads = 100;
        AbstractOptimisticTestCase.ExceptionThread[] thread = new AbstractOptimisticTestCase.ExceptionThread[numThreads];
        final CountDownLatch latch = new CountDownLatch(1);
        for (i = 0; i < numThreads; ++i) {
            thread[i] = new AbstractOptimisticTestCase.ExceptionThread(){

                public void run() {
                    try {
                        latch.await();
                        for (int i = 0; i < 5; ++i) {
                            CacheTest.this.c.put("/a", (Object)"k", (Object)"v");
                        }
                    }
                    catch (Exception e) {
                        this.setException(e);
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            thread[i].start();
        }
        latch.countDown();
        for (i = 0; i < numThreads; ++i) {
            thread[i].join();
        }
        int exceptionCount = 0;
        for (int i2 = 0; i2 < numThreads; ++i2) {
            Exception e = thread[i2].getException();
            if (e == null) continue;
            AssertJUnit.assertFalse((String)"Should never see a RollbackException - instead, expecting the CAUSE of the rollback.", (boolean)(e instanceof RollbackException));
            ++exceptionCount;
        }
        AssertJUnit.assertTrue((String)"Expecting at least ONE concurrent write exception!!", (exceptionCount > 0 ? 1 : 0) != 0);
    }

    public void testLocalTransaction() throws Exception {
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, this.c);
        TransactionManager mgr = this.c.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        this.c.put("/one/two", (Object)"key1", (Object)"value");
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        List<Class<? extends ReplicableCommand>> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals(OptimisticPrepareCommand.class, calls.get(0));
        AssertJUnit.assertEquals(CommitCommand.class, calls.get(1));
    }

    public void testRollbackTransaction() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.c);
        this.c = this.createCacheWithListener();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, this.c);
        TransactionManager mgr = this.c.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        mgr.begin();
        this.c.put("/one/two", (Object)"key1", (Object)"value");
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)this.c.getTransactionTable().getNumLocalTransactions());
        List<Class<? extends ReplicableCommand>> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals((int)1, (int)calls.size());
        AssertJUnit.assertEquals(RollbackCommand.class, calls.get(0));
    }

    public void testRemotePrepareTransaction() throws Throwable {
        this.destroyCache((Cache<Object, Object>)this.c);
        this.c = this.createCacheWithListener();
        MockInterceptor dummy = new MockInterceptor();
        this.setAlteredInterceptorChain(dummy, this.c);
        TransactionManager mgr = this.c.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.c.getCurrentTransaction(tx, true);
        this.c.put("/one/two", (Object)"key1", (Object)"value");
        GlobalTransaction gtx = this.c.getCurrentTransaction(tx, true);
        TransactionTable table = this.c.getTransactionTable();
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        WriteCommand command = (WriteCommand)entry.getModifications().get(0);
        mgr.commit();
        GlobalTransaction remoteGtx = new GlobalTransaction();
        remoteGtx.setAddress((Address)new AbstractOptimisticTestCase.DummyAddress());
        command.setGlobalTransaction(remoteGtx);
        List<WriteCommand> cacheCommands = this.injectDataVersion(entry.getModifications());
        OptimisticPrepareCommand prepareCommand = new OptimisticPrepareCommand(remoteGtx, cacheCommands, (Address)remoteGtx.getAddress(), false);
        TestingUtil.replicateCommand(this.c, (VisitableCommand)prepareCommand);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertNotNull((Object)table.get(remoteGtx));
        AssertJUnit.assertNotNull((Object)table.getLocalTransaction(remoteGtx));
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        List<Class<? extends ReplicableCommand>> calls = dummy.getAllCalled();
        AssertJUnit.assertEquals(OptimisticPrepareCommand.class, calls.get(2));
        AssertJUnit.assertEquals((int)1, (int)this.c.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)this.c.getTransactionTable().getNumLocalTransactions());
    }

    public void testRemoteCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.c);
        CacheSPI<Object, Object> cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        CacheSPI<Object, Object> cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        AssertJUnit.assertEquals((int)2, (int)cache.getMembers().size());
        AssertJUnit.assertEquals((int)2, (int)cache2.getMembers().size());
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        cache.put("/one/two", (Object)"key1", (Object)"value");
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)"value", (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)"value", (Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testTwoWayRemoteCacheBroadcast() throws Exception {
        this.destroyCache((Cache<Object, Object>)this.c);
        CacheSPI<Object, Object> cache = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        CacheSPI<Object, Object> cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        AssertJUnit.assertEquals((int)2, (int)cache.getMembers().size());
        AssertJUnit.assertEquals((int)2, (int)cache2.getMembers().size());
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.getCurrentTransaction(tx, true);
        cache.put("/one/two", (Object)"key1", (Object)"value");
        AssertJUnit.assertNotNull((Object)mgr.getTransaction());
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)"value", (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((Object)"value", (Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testConcurrentNodeRemoval() throws Exception {
        this.c.put(this.fqn, (Object)"key", (Object)"value");
        TransactionManager mgr = this.c.getTransactionManager();
        mgr.begin();
        this.c.put(this.fqn, (Object)"key2", (Object)"value2");
        Transaction tx = mgr.suspend();
        this.c.removeNode(this.fqn);
        mgr.resume(tx);
        boolean ok = false;
        try {
            mgr.commit();
        }
        catch (RollbackException rbe) {
            ok = true;
        }
        AssertJUnit.assertTrue((String)"Concurrent mod should result in a rollback", (boolean)ok);
        AssertJUnit.assertTrue((String)"The node should have been removed!", (!this.c.exists(this.fqn) ? 1 : 0) != 0);
    }

    public void testConcurrentNodeModification() throws Exception {
        this.c.put(this.fqn, (Object)"key", (Object)"value");
        TransactionManager mgr = this.c.getTransactionManager();
        mgr.begin();
        this.c.put(this.fqn, (Object)"key2", (Object)"value2");
        Transaction tx = mgr.suspend();
        this.c.put(this.fqn, (Object)"key3", (Object)"value3");
        mgr.resume(tx);
        boolean ok = false;
        try {
            mgr.commit();
        }
        catch (RollbackException rbe) {
            ok = true;
        }
        AssertJUnit.assertTrue((String)"Concurrent mod should result in a rollback", (boolean)ok);
    }

    public void testRemoveAndCreate() throws Exception {
        this.c = this.createCache();
        this.c.put(this.fqn, (Object)"key", (Object)"value");
        TransactionManager tm = this.c.getTransactionManager();
        tm.begin();
        this.c.put(this.fqn, (Object)"test", (Object)"test");
        tm.commit();
        AssertJUnit.assertEquals((int)1, (int)this.c.getRoot().getChildrenNames().size());
        tm.begin();
        this.c.removeNode(this.fqn);
        this.c.put(this.fqn, (Object)"test", (Object)"test");
        tm.commit();
        AssertJUnit.assertEquals((int)1, (int)this.c.getRoot().getChildrenNames().size());
    }

    public void testRemoveChildAfterRemoveParent() throws Exception {
        this.c = this.createCache();
        TransactionManager tm = this.c.getTransactionManager();
        this.c.put(Fqn.fromString((String)"/a/b"), (Object)"k", (Object)"v");
        tm.begin();
        this.c.removeNode(Fqn.fromString((String)"/a"));
        this.c.removeNode(Fqn.fromString((String)"/a/b"));
        tm.commit();
        this.destroyCache((Cache<Object, Object>)this.c);
    }

    public void testAddChildAfterRemoveParent() throws Exception {
        this.c = this.createCache();
        TransactionManager tm = this.c.getTransactionManager();
        this.c.put(Fqn.fromString((String)"/a/b"), (Object)"k", (Object)"v");
        tm.begin();
        this.c.removeNode(Fqn.fromString((String)"/a"));
        this.c.put(Fqn.fromString((String)"/a/b"), (Object)"k", (Object)"v");
        tm.commit();
        this.destroyCache((Cache<Object, Object>)this.c);
    }
}

