/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "optimistic"}, sequential=true, testName="optimistic.FullStackInterceptorTest")
public class FullStackInterceptorTest
extends AbstractOptimisticTestCase {
    private Log log = LogFactory.getLog(FullStackInterceptorTest.class);
    private int groupIncreaser = 0;

    public void testLocalTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testNoLocalTransaction() throws Exception {
        TestListener listener = new TestListener();
        CacheSPI<Object, Object> cache = this.createCacheWithListener(listener);
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)2, (int)listener.getNodesAdded());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createCacheWithListener();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceRollback() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createSyncReplicatedCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.rollback();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((boolean)false, (boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNull((Object)cache.getRoot().getChild((Object)"one"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testSingleInstanceDuplicateCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createSyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testValidationFailCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createSyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.suspend();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        cache.put("/one/two", (Object)"key1", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.resume(tx);
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void test2InstanceCommit() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createSyncReplicatedCache();
        CacheSPI<Object, Object> cache2 = this.createSyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        LockManager lockManager2 = TestingUtil.extractLockManager(cache2);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void test2InstanceRemove() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createSyncReplicatedCache();
        CacheSPI<Object, Object> cache2 = this.createSyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        LockManager lockManager2 = TestingUtil.extractLockManager(cache2);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache2.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        AssertJUnit.assertTrue((boolean)cache2.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager2.isLocked(cache2.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache2.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertNotNull((Object)cache2.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        cache.removeNode("/one/two");
        AssertJUnit.assertEquals((boolean)false, (boolean)cache.exists("/one/two"));
        AssertJUnit.assertEquals((boolean)false, (boolean)cache2.exists("/one/two"));
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two", (Object)"key1"));
        AssertJUnit.assertEquals(null, (Object)cache2.get("/one/two", (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testValidationFailCommit2Instances() throws Exception {
        ++this.groupIncreaser;
        CacheSPI<Object, Object> cache = this.createSyncReplicatedCache();
        CacheSPI<Object, Object> cache2 = this.createSyncReplicatedCache();
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.suspend();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        GlobalTransaction gtx = cache.getCurrentTransaction(tx, true);
        TransactionTable table = cache.getTransactionTable();
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        AssertJUnit.assertEquals((int)3, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        SamplePojo pojo2 = new SamplePojo(22, "test2");
        cache2.put("/one/two", (Object)"key1", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)1, (int)cache.getTransactionTable().getNumLocalTransactions());
        mgr.resume(tx);
        boolean fail = false;
        try {
            mgr.commit();
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertEquals((boolean)true, (boolean)fail);
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        AssertJUnit.assertEquals((int)0, (int)entry.getTransactionWorkSpace().getNodes().size());
        AssertJUnit.assertTrue((boolean)cache.exists(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getRoot().getChild((Object)"one"));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getRoot()));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)lockManager.isLocked(cache.getNode("/one/two")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one").getChild((Object)"two"));
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get(Fqn.fromString((String)"/one/two"), (Object)"key1"));
        this.destroyCache((Cache<Object, Object>)cache);
        this.destroyCache((Cache<Object, Object>)cache2);
    }

    public void testGetKeyValIsolationTransaction() throws Exception {
        SamplePojo pojo1 = new SamplePojo(21, "test-1");
        SamplePojo pojo2 = new SamplePojo(21, "test-2");
        CacheSPI<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.put("/one/two", (Object)"key1", (Object)pojo1);
        mgr.commit();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        System.out.println("Current TX " + mgr.getTransaction());
        AssertJUnit.assertEquals((Object)pojo1, (Object)cache.get("/one/two", (Object)"key1"));
        mgr.suspend();
        mgr.begin();
        System.out.println("Current TX " + mgr.getTransaction());
        cache.put("/one/two", (Object)"key2", (Object)pojo2);
        mgr.commit();
        AssertJUnit.assertEquals((Object)pojo2, (Object)cache.get("/one/two", (Object)"key2"));
        System.out.println("Current TX " + mgr.getTransaction());
        mgr.resume(tx);
        System.out.println("Current TX " + mgr.getTransaction());
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two", (Object)"key2"));
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testGetKeysIsolationTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (mgr.getTransaction() != null) {
            mgr.rollback();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        mgr.commit();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        AssertJUnit.assertEquals((int)1, (int)cache.getNode("/one/two").getKeys().size());
        mgr.suspend();
        mgr.begin();
        cache.put("/one/two", (Object)"key2", (Object)pojo);
        mgr.commit();
        AssertJUnit.assertEquals((int)2, (int)cache.getNode("/one/two").getKeys().size());
        mgr.resume(tx);
        AssertJUnit.assertEquals((int)1, (int)cache.getNode("/one/two").getKeys().size());
        mgr.commit();
        this.destroyCache((Cache<Object, Object>)cache);
    }

    public void testTxRollbackThroughConcurrentWrite() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheWithListener();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (mgr.getTransaction() != null) {
            mgr.rollback();
        }
        AssertJUnit.assertNull((Object)mgr.getTransaction());
        mgr.begin();
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumGlobalTransactions());
        AssertJUnit.assertEquals((int)0, (int)cache.getTransactionTable().getNumLocalTransactions());
        cache.put("/one/two", (Object)"key1", (Object)"val1");
        mgr.commit();
        Set keys = cache.getNode("/one/two").getKeys();
        System.out.println("keys after TX #1: " + keys);
        AssertJUnit.assertEquals((int)1, (int)keys.size());
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        cache.put("/one/two", (Object)"key2", (Object)"val2");
        mgr.suspend();
        mgr.begin();
        cache.put("/one/two", (Object)"key3", (Object)"val3");
        mgr.commit();
        keys = cache.getNode("/one/two").getKeys();
        System.out.println("keys after TX #3 committed: " + keys);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        mgr.resume(tx);
        keys = cache.getNode("/one/two").getKeys();
        System.out.println("keys after TX #2 resumed (in private workspace of TX #2): " + keys);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        try {
            mgr.commit();
            AssertJUnit.fail((String)"TX should fail as other TX incremented version number");
        }
        catch (RollbackException rollback_ex) {
            System.out.println("TX was rolled back because the other TX committed first and incremented version ID. This is the expected behavior");
        }
        keys = cache.getNode("/one/two").getKeys();
        System.out.println("keys after TX #2 was rolled back: " + keys);
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        this.destroyCache((Cache<Object, Object>)cache);
    }

    protected CacheSPI<Object, Object> createSyncReplicatedCache() throws Exception {
        return this.createReplicatedCache("temp" + this.groupIncreaser, Configuration.CacheMode.REPL_SYNC);
    }

    protected CacheSPI<Object, Object> createSyncReplicatedCacheAsyncCommit() throws Exception {
        CacheSPI<Object, Object> cache = this.createReplicatedCache("temp" + this.groupIncreaser, Configuration.CacheMode.REPL_SYNC, false);
        cache.getConfiguration().setSyncCommitPhase(false);
        cache.getConfiguration().setSyncRollbackPhase(false);
        cache.create();
        cache.start();
        return cache;
    }

    public void testPuts() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        mgr.begin();
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        mgr.begin();
        AssertJUnit.assertNull((Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        mgr.resume(tx);
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
    }

    public void testRemoves() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.begin();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        cache.removeNode(this.fqn);
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        mgr.begin();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        mgr.resume(tx);
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        mgr.commit();
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
    }

    public void testRemovesBeforeGet() throws Exception {
        CacheSPI<Object, Object> cache = this.createCache();
        TransactionManager mgr = cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.begin();
        cache.removeNode(this.fqn);
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        Transaction tx = mgr.getTransaction();
        mgr.suspend();
        mgr.begin();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        mgr.commit();
        mgr.resume(tx);
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
        mgr.commit();
        AssertJUnit.assertNull((Object)cache.getNode(this.fqn));
    }

    public void testLoopedPutAndGet() throws Exception {
        try {
            this.log.debug((Object)"Starting test");
            CacheSPI<Object, Object> cache1 = this.createSyncReplicatedCache();
            CacheSPI<Object, Object> cache2 = this.createSyncReplicatedCache();
            this.log.debug((Object)"Created caches");
            TransactionManager mgr = cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
            int numLoops = 5;
            int numPuts = 5;
            this.log.debug((Object)("Starting " + numLoops + " loops"));
            for (int i = 0; i < numLoops; ++i) {
                this.log.debug((Object)(" *** in loop " + i));
                mgr.begin();
                for (int j = 0; j < numPuts; ++j) {
                    cache1.put(Fqn.fromString((String)("/profiler/node" + i)), (Object)("key" + j), (Object)("value" + j));
                }
                this.log.debug((Object)"*** >> Out of put loop");
                mgr.commit();
            }
            this.destroyCache((Cache<Object, Object>)cache1);
            this.destroyCache((Cache<Object, Object>)cache2);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error: ", (Throwable)e);
            AssertJUnit.assertFalse((String)"Threw exception!", (boolean)true);
            throw e;
        }
    }

    @Test(enabled=false)
    public void testAsynchronousCommit() throws Exception {
        CacheSPI<Object, Object> cache1 = this.createSyncReplicatedCacheAsyncCommit();
        CacheSPI<Object, Object> cache2 = this.createSyncReplicatedCacheAsyncCommit();
        TransactionManager tm1 = cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        Fqn fqn = Fqn.fromString((String)"/test/node");
        String KEY = "key";
        String VALUE1 = "value1";
        tm1.begin();
        cache1.put(fqn, (Object)KEY, (Object)VALUE1);
        tm1.commit();
        AssertJUnit.assertEquals((String)"Known issue JBCACHE-1201: Correct node2 value", (Object)VALUE1, (Object)cache2.get(fqn, (Object)KEY));
        AssertJUnit.assertEquals((String)"Correct node1 value", (Object)VALUE1, (Object)cache1.get(fqn, (Object)KEY));
        this.destroyCache((Cache<Object, Object>)cache1);
        this.destroyCache((Cache<Object, Object>)cache2);
    }
}

