/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true, testName="optimistic.OptimisticCreateIfNotExistsInterceptorTest")
public class OptimisticCreateIfNotExistsInterceptorTest
extends AbstractOptimisticTestCase {
    protected TransactionManager txManager;
    protected Transaction tx;
    protected GlobalTransaction gtx;
    protected TransactionTable table;
    protected OptimisticTransactionContext entry;
    protected TransactionWorkspace workspace;
    CacheSPI cache;
    MockInterceptor dummy;
    SamplePojo pojo;

    @BeforeMethod
    public void setUp() throws Exception {
        this.pojo = new SamplePojo(21, "test");
        this.cache = this.createCache();
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        this.dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (CommandInterceptor)interceptor);
        this.setupTransactionsInInvocationCtx(this.cache);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    protected void setupTransactionsInInvocationCtx(CacheSPI cache) throws Exception {
        this.txManager = DummyTransactionManager.getInstance();
        this.txManager.begin();
        this.table = cache.getTransactionTable();
        this.gtx = cache.getCurrentTransaction();
        this.tx = this.txManager.getTransaction();
        this.entry = (OptimisticTransactionContext)this.table.get(this.gtx);
        this.workspace = this.entry.getTransactionWorkSpace();
        this.setupTransactions(cache, this.tx);
    }

    public void testNodeCreation() throws Exception {
        this.cache.put("/one/two", (Object)"key1", (Object)this.pojo);
        AssertJUnit.assertEquals((int)3, (int)this.workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/")));
        AssertJUnit.assertEquals(null, (Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)this.entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(PutKeyValueCommand.class, this.dummy.getCalledCommandClass());
        this.txManager.commit();
    }

    public void testInvalidTransaction() throws Exception {
        this.cache.put("/one/two", (Object)"key1", (Object)this.pojo);
        AssertJUnit.assertEquals((int)3, (int)this.workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/")));
        AssertJUnit.assertEquals(null, (Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)this.entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(PutKeyValueCommand.class, this.dummy.getCalledCommandClass());
        this.txManager.commit();
        this.cache.getInvocationContext().setGlobalTransaction(null);
        this.cache.getInvocationContext().setTransaction(null);
        this.cache.getInvocationContext().setTransactionContext(null);
        try {
            this.cache.put("/one/two/three", (Object)"key1", (Object)this.pojo);
            AssertJUnit.assertTrue((String)"Should never be reched", (boolean)false);
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
    }

    public void testMultiplePut() throws Exception {
        this.cache.put("/one/two", (Object)"key1", (Object)this.pojo);
        this.cache.put("/one/two", (Object)"key2", (Object)this.pojo);
        AssertJUnit.assertEquals((int)3, (int)this.workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/")));
        AssertJUnit.assertEquals(null, (Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)this.entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(PutKeyValueCommand.class, this.dummy.getCalledCommandClass());
        this.txManager.commit();
    }
}

