/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true, testName="optimistic.ThreadedCacheAccessTest")
public class ThreadedCacheAccessTest
extends AbstractOptimisticTestCase {
    private static final Log log = LogFactory.getLog(ThreadedCacheAccessTest.class);
    private final int numThreads = 10;
    private final int numLoopsPerThread = 1000;
    private final int writeFrequency = 5;
    private final String key = "key";
    private final String value = "value";
    private CacheSPI cache;
    private WorkerThread[] threads;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.destroyCache((Cache<Object, Object>)this.cache);
        this.cache = null;
        this.threads = null;
    }

    public void testThreadedMostlyReads() throws Exception {
        this.cache = this.createCache();
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.threads = new WorkerThread[10];
        for (int i = 0; i < 10; ++i) {
            this.threads[i] = new WorkerThread();
            this.threads[i].start();
        }
        for (WorkerThread t : this.threads) {
            t.join();
            if (t.e == null) continue;
            throw t.e;
        }
    }

    public class WorkerThread
    extends Thread {
        Exception e = null;

        public WorkerThread() {
            this.setDaemon(true);
        }

        public void run() {
            log.debug((Object)(this.getName() + " starting up ... "));
            for (int j = 0; j < 1000; ++j) {
                TransactionManager tm = ThreadedCacheAccessTest.this.cache.getTransactionManager();
                boolean write = j % 5 == 0;
                try {
                    tm.begin();
                    ThreadedCacheAccessTest.this.cache.get(ThreadedCacheAccessTest.this.fqn, (Object)"key");
                    if (write) {
                        ThreadedCacheAccessTest.this.cache.put(ThreadedCacheAccessTest.this.fqn, (Object)"key", (Object)("value" + j));
                    }
                    tm.commit();
                    continue;
                }
                catch (Exception e) {
                    if (!write) {
                        this.e = e;
                    }
                    try {
                        if (tm.getTransaction() != null) {
                            tm.rollback();
                        }
                    }
                    catch (Exception e2) {
                        log.error((Object)"Rollback failed!", (Throwable)e2);
                    }
                    if (!write) break;
                }
            }
        }
    }
}

