/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import java.util.HashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="options.PessimisticFailSilentlyTest")
public class PessimisticFailSilentlyTest {
    private CacheSPI cache;
    private TransactionManager manager;
    private Transaction tx;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private String key = "key";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache != null) {
            this.tearDown();
        }
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setLockAcquisitionTimeout(100L);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.start();
        this.manager = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.tx != null) {
            try {
                this.manager.resume(this.tx);
                this.manager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    public void testPutKeyValue() throws Exception {
        this.manager.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.put(this.fqn, (Object)this.key, (Object)"value2");
    }

    public void testPutData() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(this.key, "value");
        this.manager.begin();
        this.cache.put(this.fqn, data);
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.put(this.fqn, data);
    }

    public void testRemoveNode() throws Exception {
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        this.manager.begin();
        this.cache.get(this.fqn, (Object)this.key);
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.removeNode(this.fqn);
    }

    public void testRemoveKey() throws Exception {
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        this.manager.begin();
        this.cache.get(this.fqn, (Object)this.key);
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.remove(this.fqn, (Object)this.key);
    }

    public void testGetNode() throws Exception {
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        this.manager.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)"value2");
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.getNode(this.fqn);
    }

    public void testGetKey() throws Exception {
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        this.manager.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)"value2");
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.get(this.fqn, (Object)this.key);
    }

    public void testGetChildrenNames() throws Exception {
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
        this.manager.begin();
        this.cache.put(this.fqn, (Object)this.key, (Object)"value2");
        this.tx = this.manager.suspend();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.getChildrenNames(this.fqn);
    }

    public void testPutThatWillFail() throws Exception {
        this.manager.begin();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tx = this.manager.suspend();
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        this.manager.begin();
        this.cache.getInvocationContext().getOptionOverrides().setFailSilently(true);
        this.cache.put(this.fqn, (Object)"x", (Object)"y");
        this.manager.commit();
    }
}

