/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="options.PessimisticLockAcquisitionTimeoutTest")
public class PessimisticLockAcquisitionTimeoutTest {
    private static final Log log = LogFactory.getLog(PessimisticLockAcquisitionTimeoutTest.class);
    private static final Fqn FQNA = Fqn.fromString((String)"/A");
    private static final Fqn FQNB = Fqn.fromString((String)"/B");
    private static final String KEY = "key";
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private CacheSPI<Object, Object> cache;
    private Option option;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setCacheMode("REPL_SYNC");
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        this.cache.start();
        this.option = new Option();
        this.option.setLockAcquisitionTimeout(0);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    public void testSimplePut() throws Exception {
        log.info((Object)"++++ testSimplePut() ++++");
        this.simplePutTest(false);
    }

    public void testSimplePutWithTx() throws Exception {
        log.info((Object)"++++ testSimplePutWithTx() ++++");
        this.simplePutTest(true);
    }

    private void simplePutTest(boolean useTx) throws Exception {
        TransactionManager tm = useTx ? this.cache.getTransactionManager() : null;
        LowTimeoutSetter setter = new LowTimeoutSetter(tm);
        setter.start();
        setter.join(2000L);
        if (!setter.finished) {
            setter.interrupt();
            AssertJUnit.fail((String)"Puts failed to complete in a timely manner");
        }
        AssertJUnit.assertNull((String)"LowTimeoutSetter saw no TimeoutException", (Object)((Object)setter.te));
        AssertJUnit.assertNull((String)"LowTimeoutSetter saw no misc Exception", (Object)setter.failure);
        AssertJUnit.assertEquals((String)("Cache correct for " + FQNA), (Object)VALUE2, (Object)this.cache.get(FQNA, (Object)KEY));
        AssertJUnit.assertEquals((String)("Cache correct for " + FQNB), (Object)VALUE2, (Object)this.cache.get(FQNB, (Object)KEY));
    }

    public void testContestedPut() throws Exception {
        log.info((Object)"++++ testContestedPut() ++++");
        this.contestedPutTest(false);
    }

    public void testContestedPutWithTx() throws Exception {
        log.info((Object)"++++ testContestedPutWithTx() ++++");
        this.contestedPutTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contestedPutTest(boolean tx) throws Exception {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        LowTimeoutSetter setter = null;
        try {
            this.cache.put(FQNA, (Object)KEY, (Object)VALUE1);
            setter = new LowTimeoutSetter((TransactionManager)(tx ? mgr : null));
            setter.start();
            setter.join(2000L);
            if (!setter.finished) {
                setter.interrupt();
                AssertJUnit.fail((String)"Puts failed to complete in a timely manner");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mgr.commit();
            throw throwable;
        }
        mgr.commit();
        AssertJUnit.assertNotNull((String)"LowTimeoutSetter saw TimeoutException", (Object)((Object)setter.te));
        AssertJUnit.assertNull((String)"LowTimeoutSetter saw no misc Exception", (Object)setter.failure);
        AssertJUnit.assertEquals((String)("Cache correct for " + FQNA), (Object)VALUE1, (Object)this.cache.get(FQNA, (Object)KEY));
        AssertJUnit.assertEquals((String)("Cache correct for " + FQNB), (Object)VALUE2, (Object)this.cache.get(FQNB, (Object)KEY));
    }

    public void testSimpleRead() throws Exception {
        log.info((Object)"++++++ testSimpleRead() ++++++");
        this.simpleReadTest(false);
    }

    public void testSimpleReadWithTx() throws Exception {
        log.info((Object)"++++++ testSimpleReadWithTx() ++++++");
        this.simpleReadTest(true);
    }

    private void simpleReadTest(boolean useTx) throws Exception {
        TransactionManager tm = useTx ? this.cache.getTransactionManager() : null;
        LowTimeoutReader reader = new LowTimeoutReader(tm);
        this.cache.put(FQNA, (Object)KEY, (Object)VALUE1);
        reader.start();
        reader.join(2000L);
        if (!reader.finished) {
            reader.interrupt();
            AssertJUnit.fail((String)"Read failed to complete in a timely manner");
        }
        AssertJUnit.assertNull((String)"LowTimeoutSetter saw no TimeoutException", (Object)((Object)reader.te));
        AssertJUnit.assertNull((String)"LowTimeoutSetter saw no misc Exception", (Object)reader.failure);
        AssertJUnit.assertEquals((String)("LowTimeoutSetter correct for " + FQNA), (Object)VALUE1, (Object)reader.value);
    }

    public void testContestedRead() throws Exception {
        log.info((Object)"++++++ testContestedRead() ++++++");
        this.contestedReadTest(false);
    }

    public void testContestedReadWithTx() throws Exception {
        log.info((Object)"++++++ testContestedReadWithTx() ++++++");
        this.contestedReadTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void contestedReadTest(boolean tx) throws Exception {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        LowTimeoutReader reader = null;
        try {
            this.cache.put(FQNA, (Object)KEY, (Object)VALUE1);
            reader = new LowTimeoutReader((TransactionManager)(tx ? mgr : null));
            reader.start();
            reader.join(2000L);
            if (!reader.finished) {
                reader.interrupt();
                AssertJUnit.fail((String)"Read failed to complete in a timely manner");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mgr.commit();
            throw throwable;
        }
        mgr.commit();
        AssertJUnit.assertNotNull((String)"LowTimeoutSetter saw TimeoutException", (Object)((Object)reader.te));
        AssertJUnit.assertNull((String)"LowTimeoutSetter saw no misc Exception", (Object)reader.failure);
        AssertJUnit.assertNull((String)("LowTimeoutSetter unable to read " + FQNA), (Object)reader.value);
    }

    class LowTimeoutReader
    extends Thread {
        TransactionManager tm;
        TimeoutException te;
        Throwable failure;
        Object value;
        boolean finished;

        LowTimeoutReader(TransactionManager tm) {
            this.tm = tm;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block11: {
                    try {
                        try {
                            if (this.tm != null) {
                                this.tm.begin();
                            }
                            PessimisticLockAcquisitionTimeoutTest.this.cache.getInvocationContext().setOptionOverrides(PessimisticLockAcquisitionTimeoutTest.this.option);
                            this.value = PessimisticLockAcquisitionTimeoutTest.this.cache.get(FQNA, (Object)PessimisticLockAcquisitionTimeoutTest.KEY);
                        }
                        catch (TimeoutException te) {
                            this.te = te;
                            Object var3_2 = null;
                            if (this.tm != null) {
                                this.tm.commit();
                            }
                            this.finished = true;
                            return;
                        }
                        catch (Exception e) {
                            if (this.tm == null) throw e;
                            this.tm.setRollbackOnly();
                            throw e;
                        }
                        Object var3_1 = null;
                        if (this.tm == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        if (this.tm != null) {
                            this.tm.commit();
                        }
                        this.finished = true;
                        throw throwable;
                    }
                    this.tm.commit();
                }
                this.finished = true;
                return;
            }
            catch (Throwable t) {
                this.failure = t;
            }
        }
    }

    class LowTimeoutSetter
    extends Thread {
        TransactionManager tm;
        TimeoutException te;
        Throwable failure;
        boolean finished;

        LowTimeoutSetter(TransactionManager tm) {
            this.tm = tm;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block11: {
                    try {
                        try {
                            if (this.tm != null) {
                                this.tm.begin();
                            }
                            PessimisticLockAcquisitionTimeoutTest.this.cache.put(FQNB, (Object)PessimisticLockAcquisitionTimeoutTest.KEY, (Object)PessimisticLockAcquisitionTimeoutTest.VALUE2);
                            PessimisticLockAcquisitionTimeoutTest.this.cache.getInvocationContext().setOptionOverrides(PessimisticLockAcquisitionTimeoutTest.this.option);
                            PessimisticLockAcquisitionTimeoutTest.this.cache.put(FQNA, (Object)PessimisticLockAcquisitionTimeoutTest.KEY, (Object)PessimisticLockAcquisitionTimeoutTest.VALUE2);
                        }
                        catch (TimeoutException te) {
                            this.te = te;
                            Object var3_2 = null;
                            if (this.tm != null) {
                                this.tm.commit();
                            }
                            this.finished = true;
                            return;
                        }
                        catch (Exception e) {
                            if (this.tm == null) throw e;
                            this.tm.setRollbackOnly();
                            throw e;
                        }
                        Object var3_1 = null;
                        if (this.tm == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        if (this.tm != null) {
                            this.tm.commit();
                        }
                        this.finished = true;
                        throw throwable;
                    }
                    this.tm.commit();
                }
                this.finished = true;
                return;
            }
            catch (Throwable t) {
                this.failure = t;
            }
        }
    }
}

