/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options.cachemodelocal;

import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.legacy.write.PessPutDataMapCommand;
import org.jboss.cache.commands.legacy.write.PessPutKeyValueCommand;
import org.jboss.cache.commands.legacy.write.PessRemoveKeyCommand;
import org.jboss.cache.commands.legacy.write.PessRemoveNodeCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.options.cachemodelocal.CacheModeLocalTestBase;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"}, testName="options.cachemodelocal.AsyncReplPessLocksTest")
public class AsyncReplPessLocksTest
extends CacheModeLocalTestBase {
    ReplicationListener current;
    Map<Cache, ReplicationListener> cache2Listener = new HashMap<Cache, ReplicationListener>(2);

    public AsyncReplPessLocksTest() {
        this.cacheMode = Configuration.CacheMode.REPL_ASYNC;
        this.nodeLockingScheme = "PESSIMISTIC";
    }

    @Override
    protected void registerReplicationCommand(CacheSPI<String, String> cache, Class<? extends ReplicableCommand> what) {
        if (what == PutDataMapCommand.class) {
            what = PessPutDataMapCommand.class;
        }
        if (what == PutKeyValueCommand.class) {
            what = PessPutKeyValueCommand.class;
        }
        if (what == RemoveKeyCommand.class) {
            what = PessRemoveKeyCommand.class;
        }
        if (what == RemoveNodeCommand.class) {
            what = PessRemoveNodeCommand.class;
        }
        this.getCacheListener((Cache)cache).expect(what);
    }

    @Override
    protected void verifyReplication() {
        this.current.waitForReplicationToOccur(2000L);
    }

    public ReplicationListener getCacheListener(Cache cache) {
        this.current = this.cache2Listener.get(cache);
        if (this.current == null) {
            this.current = new ReplicationListener(cache);
            this.cache2Listener.put(cache, this.current);
        }
        return this.current;
    }
}

