/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.statetransfer.DefaultStateTransferManager;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestingUtil;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="passivation.PassivationTestsBase")
public abstract class PassivationTestsBase
extends AbstractCacheLoaderTestBase {
    Log log = LogFactory.getLog(this.getClass());
    protected ThreadLocal<CacheSPI<Object, Object>> cacheTL = new ThreadLocal();
    ThreadLocal<CacheLoader> loaderTL = new ThreadLocal();
    static final Fqn FQN = Fqn.fromString((String)"/key");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        cache.getConfiguration().setCacheMode("local");
        this.cacheTL.set((CacheSPI<Object, Object>)cache);
        this.configureCache();
        cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cache.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        cache.create();
        cache.start();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        this.loaderTL.set(loader);
    }

    protected abstract void configureCache() throws Exception;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        this.log.info((Object)"**** TEARING DOWN ****");
        if (loader != null) {
            loader.remove(Fqn.ROOT);
        }
        TestingUtil.killCaches(new Cache[]{cache});
        this.cacheTL.set(null);
        this.loaderTL.set(null);
    }

    protected void addDelay() {
    }

    protected boolean exists(String fqn, String key) {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        NodeSPI n = cache.peek(Fqn.fromString((String)fqn), false, false);
        if (key == null) {
            return n != null;
        }
        return n != null && n.getKeysDirect().contains(key);
    }

    protected boolean exists(String fqn) {
        return this.exists(fqn, null);
    }

    public void testPutPassivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        cache.removeNode(NODE);
        this.addDelay();
        Object retval = cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        retval = cache.put(NODE, (Object)"key", (Object)20);
        this.addDelay();
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        cache.evict(NODE, true);
        this.addDelay();
        retval = cache.put(NODE, (Object)"key", (Object)30);
        AssertJUnit.assertFalse((boolean)loader.exists(NODE));
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testPut2Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn NODE = Fqn.fromString((String)"/a/b/c");
        String KEY = "key";
        cache.removeNode(NODE);
        this.addDelay();
        Object retval = cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = cache.put(NODE, (Object)"key", (Object)20);
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        cache.evict(NODE, true);
        cache.evict(Fqn.fromString((String)"/a/b"), true);
        cache.evict(Fqn.fromString((String)"/a"), true);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a/b/c")));
        retval = cache.put(NODE, (Object)"key", (Object)30);
        AssertJUnit.assertFalse((boolean)loader.exists(NODE));
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testSerializationPassivation() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn fqn = Fqn.fromString((String)"/mypojo");
        SamplePojo pojo = new SamplePojo(39, "Hany");
        pojo.getHobbies().add("Running");
        pojo.getHobbies().add("Beerathlon");
        pojo.getHobbies().add("Triathlon");
        cache.put(fqn, (Object)322649, (Object)pojo);
        this.addDelay();
        AssertJUnit.assertNotNull((Object)cache.get(fqn, (Object)322649));
        cache.evict(fqn, false);
        try {
            AssertJUnit.assertTrue((boolean)loader.exists(fqn));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        SamplePojo pojo2 = (SamplePojo)cache.get(fqn, (Object)322649);
        try {
            AssertJUnit.assertFalse((boolean)loader.exists(fqn));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        AssertJUnit.assertNotNull((Object)pojo2);
        AssertJUnit.assertEquals((int)39, (int)pojo2.getAge());
        AssertJUnit.assertEquals((String)"Hany", (String)pojo2.getName());
        AssertJUnit.assertEquals((int)3, (int)pojo2.getHobbies().size());
    }

    public void testPopulate() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < 10; ++i) {
                m.put("key" + i, "val" + i);
            }
            cache.put("/a/b/c", m);
            cache.getCacheLoaderManager().preload(Fqn.fromString((String)"/1/2/3/4/5"), true, true);
            cache.put("/1/2/3/4/5", null);
            cache.put("/1/2/3/4/5/a", null);
            cache.put("/1/2/3/4/5/b", null);
            cache.put("/1/2/3/4/5/c", null);
            cache.put("/1/2/3/4/5/d", null);
            cache.put("/1/2/3/4/5/e", null);
            cache.put("/1/2/3/4/5/d/one", null);
            cache.put("/1/2/3/4/5/d/two", null);
            cache.put("/1/2/3/4/5/d/three", null);
            System.out.println("cache: " + cache);
            assert (this.exists("/1/2/3/4"));
            assert (this.exists("/a/b/c"));
            assert (!this.exists("/a/b/c/d"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testPreloadingPassivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.removeNode(Fqn.ROOT);
        cache.put("1/2/3/4/5/d", (Object)"key", (Object)"val");
        cache.evict(Fqn.fromString((String)"1/2/3/4/5/d"));
        System.out.println("-- checking for 1/2/3/4/5/d");
        this.addDelay();
        try {
            AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"1/2/3/4/5/d")));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
        cache.getNode("1/2/3/4/5/d");
        AssertJUnit.assertEquals((boolean)true, (boolean)loader.exists(Fqn.fromString((String)"1/2/3/4/5/d")));
        assert (this.exists("1/2/3/4/5/d"));
        System.out.println("-- 1/2/3/4/5/d exists");
        cache.get("1/2/3/4/5/d", (Object)"key");
        AssertJUnit.assertEquals((boolean)false, (boolean)loader.exists(Fqn.fromString((String)"1/2/3/4/5/d")));
    }

    public void testCacheLoading2() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Set keys = null;
        cache.put("/a/b/c", (Object)"key", (Object)"val");
        keys = cache.getNode(Fqn.fromString((String)"/a/b/c")).getKeys();
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)1, (int)keys.size());
    }

    public void testExists() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/eins/zwei/drei", (Object)"key1", (Object)"val1");
        assert (this.exists("/eins/zwei/drei"));
        assert (this.exists("/eins/zwei/drei", "key1"));
        assert (!this.exists("/eins/zwei/drei", "key2"));
        assert (!this.exists("/uno/due/tre"));
        assert (!this.exists("/une/due/tre", "key1"));
    }

    public void testGetChildren() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/d/one", null);
        cache.put("/d/two", null);
        cache.put("/d/three", null);
        cache.getNode("/d");
        Set children = cache.getNode("/d").getChildrenNames();
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("one"));
        AssertJUnit.assertTrue((boolean)children.contains("two"));
        AssertJUnit.assertTrue((boolean)children.contains("three"));
    }

    public void testGetChildrenWithEvictionPassivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/b/c/1", null);
        cache.put("/a/b/c/2", null);
        cache.put("/a/b/c/3", null);
        cache.evict(Fqn.fromString((String)"/a/b/c/1"));
        cache.evict(Fqn.fromString((String)"/a/b/c/2"));
        cache.evict(Fqn.fromString((String)"/a/b/c/3"));
        cache.evict(Fqn.fromString((String)"/a/b/c"));
        cache.evict(Fqn.fromString((String)"/a/b"));
        cache.evict(Fqn.fromString((String)"/a"));
        cache.evict(Fqn.fromString((String)"/"));
        this.addDelay();
        Set children = cache.getNode("/a/b/c").getChildrenNames();
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a/b/c")));
        cache.get("/a/b/c/1", (Object)"test");
        cache.get("/a/b/c/2", (Object)"test");
        cache.get("/a/b/c/3", (Object)"test");
        cache.get("/a/b/c", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/b/c/1")));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/b/c/2")));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/b/c/3")));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/b/c")));
    }

    public void testGetChildren2() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/1", null);
            cache.put("a", null);
            Set children = cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren3() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/1", null);
            cache.put("a", null);
            Set children = cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren4() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        if (!cache.exists("/a/b/c")) {
            cache.put("/a/b/c", null);
        }
        Set children = cache.getChildrenNames((Fqn)null);
        AssertJUnit.assertTrue((boolean)children.isEmpty());
    }

    public void testGetChildren5() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/1", null);
            cache.put("/a/2", null);
            cache.put("/a/3", null);
            NodeSPI n = cache.getNode("/a");
            AssertJUnit.assertNotNull((Object)n);
            Set children = n.getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren6Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        AssertJUnit.assertNotNull((Object)cache.getNode("/a"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/2")));
        cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/3")));
        cache.get("/a", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren7Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.put("/a", (Object)"test", (Object)"test");
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        assert (!this.exists("/a"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        Object val = cache.get("/a", (Object)"test");
        AssertJUnit.assertEquals((String)"attributes weren't loaded", (Object)"test", (Object)val);
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/2")));
        cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/3")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren8Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        AssertJUnit.assertNull((Object)cache.get("/a/1", (Object)"test"));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren9Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/2")));
        cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/3")));
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a")));
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/2")));
        cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/3")));
        children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testGetChildren10Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        cache.get("/a/1", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        cache.get("/a/2", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/2")));
        cache.get("/a/3", (Object)"test");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a/3")));
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/a")));
    }

    public void testRemoveData() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String key = "/x/y/z/";
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        AssertJUnit.assertEquals((int)3, (int)cache.getNode(key).getKeys().size());
        cache.getNode(key).clearData();
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)0, (int)keys.size());
        cache.removeNode("/x");
        Object val = cache.get(key, (Object)"keyA");
        AssertJUnit.assertNull((Object)val);
    }

    public void testRemoveData2Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        this.addDelay();
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        cache.getNode(key).clearData();
        cache.evict(key);
        this.addDelay();
        keys = cache.getNode(key).getKeys();
        AssertJUnit.assertFalse((boolean)loader.exists(key));
        AssertJUnit.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveData3Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        cache.evict(key);
        AssertJUnit.assertTrue((boolean)loader.exists(key));
        cache.getNode(key).clearData();
        keys = cache.getNode(key).getKeys();
        AssertJUnit.assertFalse((boolean)loader.exists(key));
        AssertJUnit.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveKey() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String key = "/x/y/z/";
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        cache.remove(key, (Object)"keyA");
        AssertJUnit.assertEquals((int)2, (int)cache.getNode(key).getKeys().size());
        cache.removeNode("/x");
    }

    public void testRemoveKey2() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        Object retval = null;
        cache.removeNode(NODE);
        retval = cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = cache.remove(NODE, (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.addDelay();
        retval = cache.remove(NODE, (Object)"key");
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemoveKey3Passivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        Object retval = null;
        cache.removeNode(NODE);
        retval = cache.put(NODE, (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        cache.evict(NODE);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(NODE));
        AssertJUnit.assertEquals((Object)10, loader.get(NODE).get("key"));
        retval = cache.remove(NODE, (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        AssertJUnit.assertFalse((boolean)loader.exists(NODE));
        cache.evict(NODE);
        this.addDelay();
        retval = cache.remove(NODE, (Object)"key");
        AssertJUnit.assertFalse((boolean)loader.exists(NODE));
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemove() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String key = "/x/y/z/";
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        cache.removeNode("/x");
        AssertJUnit.assertNull((Object)cache.get(key, (Object)"keyA"));
        this.addDelay();
        Set keys = cache.getKeys(key);
        AssertJUnit.assertNull((Object)keys);
        cache.removeNode("/x");
    }

    public void testRemoveRoot() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        AssertJUnit.assertEquals((int)0, (int)cache.getRoot().getKeys().size());
        cache.put("/1/2/3/4/5", null);
        cache.put("uno/due/tre", null);
        cache.put("1/2/3/a", null);
        cache.put("/eins/zwei/drei", null);
        cache.put("/one/two/three", null);
        cache.removeNode(Fqn.ROOT);
        AssertJUnit.assertEquals((int)0, (int)cache.getRoot().getKeys().size());
    }

    public void testEvictionWithCacheLoaderPassivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/first/second", (Object)"key1", (Object)"val1");
        cache.put("/first/second/third", (Object)"key2", (Object)"val2");
        cache.evict(Fqn.fromString((String)"/first/second"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/first/second")));
        assert (this.exists("/first"));
        String val = (String)cache.get("/first/second", (Object)"key1");
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/first/second")));
        AssertJUnit.assertEquals((String)"val1", (String)val);
        String val2 = (String)cache.get("/first/second/third", (Object)"key2");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/first/second/third")));
        AssertJUnit.assertEquals((String)"val2", (String)val2);
        assert (this.exists("/first/second/third"));
        assert (this.exists("/first/second"));
        assert (this.exists("/first"));
    }

    public void testEvictionWithCacheLoaderPassivation2() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/first/second/third", (Object)"key1", (Object)"val1");
        cache.evict(Fqn.fromString((String)"/first/second/third"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/first/second/third")));
        assert (this.exists("/first/second"));
        assert (this.exists("/first"));
        String val = (String)cache.get("/first/second/third", (Object)"key1");
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/first/second/third")));
        AssertJUnit.assertEquals((String)"val1", (String)val);
        assert (this.exists("/first/second/third"));
        assert (this.exists("/first/second"));
        assert (this.exists("/first"));
    }

    public void testEvictionWithGetChildrenNamesPassivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a/1")));
        cache.evict(Fqn.fromString((String)"/a/2"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a/2")));
        cache.evict(Fqn.fromString((String)"/a/3"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a/3")));
        cache.evict(Fqn.fromString((String)"/a"));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/a")));
        this.addDelay();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        mgr.getTransaction();
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
        mgr.commit();
    }

    public void testPutDataMapAfterPassivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn f = Fqn.fromString((String)"/a");
        assert (!cache.exists(f));
        assert (!loader.exists(f));
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("one", "one");
        input.put("two", "two");
        cache.put(f, input);
        cache.evict(f);
        input = new HashMap();
        input.put("one", "oneA");
        cache.put(f, input);
        Map data = cache.getRoot().getChild(f).getData();
        AssertJUnit.assertEquals((String)"incorrect # of entries", (int)2, (int)data.size());
        AssertJUnit.assertEquals((String)"Has key 'one", (Object)"oneA", data.get("one"));
        AssertJUnit.assertEquals((String)"Has key 'two", (Object)"two", data.get("two"));
    }

    public void testTxPutCommit() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        mgr.commit();
        AssertJUnit.assertNotNull((Object)cache.getNode("/one/two/three").getKeys());
        AssertJUnit.assertEquals((Object)"val1", (Object)cache.get(Fqn.fromString((String)"/one/two/three"), (Object)"key1"));
        mgr.begin();
        cache.evict(Fqn.fromString((String)"/one/two/three"));
        cache.evict(Fqn.fromString((String)"/one/two/three/four"));
        mgr.commit();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/one/two/three")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/one/two/three/four")));
        AssertJUnit.assertNotNull((Object)cache.getNode("/one/two/three").getKeys());
        Set children = cache.getNode("/one").getChildrenNames();
        AssertJUnit.assertEquals((int)1, (int)children.size());
        cache.removeNode(Fqn.ROOT);
    }

    public void testTxPutRollback() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        cache.removeNode("/one");
        this.addDelay();
        mgr.begin();
        cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        mgr.rollback();
        this.addDelay();
        AssertJUnit.assertNull((Object)cache.getNode("/one/two/three"));
        assert (cache.getNode("/one") == null);
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/one/two/three")));
        AssertJUnit.assertFalse((boolean)loader.exists(Fqn.fromString((String)"/one/two/three/four")));
    }

    public void testPassivationAndActivation() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn NODE = Fqn.fromString((String)"/test");
        loader.remove(Fqn.fromString((String)"/"));
        cache.put(NODE, (Object)"key", (Object)"val");
        AssertJUnit.assertNull((String)"value cannot be passivated yet (only on eviction)", (Object)loader.get(NODE));
        cache.evict(NODE);
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfAttributes());
        Object val = loader.get(NODE).get("key");
        AssertJUnit.assertNotNull((String)"value must have been passivated on evict()", val);
        AssertJUnit.assertEquals(val, (Object)"val");
        Object val2 = cache.get(NODE, (Object)"key");
        AssertJUnit.assertNotNull((Object)val2);
        AssertJUnit.assertEquals(val, (Object)val2);
        AssertJUnit.assertNull((String)"value should have been deleted from store on activation", (Object)loader.get(NODE));
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations();
    }

    public void testBasicOperationsTransactional() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.doTestBasicOperations();
        mgr.commit();
    }

    private void doTestBasicOperations() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        this.doPutTests(Fqn.fromString((String)"/key"));
        this.doRemoveTests(Fqn.fromString((String)"/key"));
        this.doPutTests(Fqn.fromString((String)"/key1"));
        this.doPutTests(Fqn.fromString((String)"/key3"));
        this.doPutTests(Fqn.fromString((String)"/key2"));
        AssertJUnit.assertEquals((int)4, (int)loader.get(Fqn.fromString((String)"/key1")).size());
        AssertJUnit.assertEquals((int)4, (int)loader.get(Fqn.fromString((String)"/key2")).size());
        AssertJUnit.assertEquals((int)4, (int)loader.get(Fqn.fromString((String)"/key3")).size());
        this.doRemoveTests(Fqn.fromString((String)"/key2"));
        this.doRemoveTests(Fqn.fromString((String)"/key3"));
        this.doRemoveTests(Fqn.fromString((String)"/key1"));
        AssertJUnit.assertEquals(null, (Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertEquals(null, (Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertEquals(null, (Object)loader.get(Fqn.fromString((String)"/key3")));
    }

    private void doPutTests(Fqn fqn) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        AssertJUnit.assertTrue((!loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        oldVal = loader.put(fqn, (Object)"three", (Object)"four");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", loader.get(fqn).get("one"));
        AssertJUnit.assertEquals((Object)"four", loader.get(fqn).get("three"));
        this.addDelay();
        oldVal = loader.put(fqn, (Object)"one", (Object)"xxx");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"xxx", (Object)oldVal);
        this.addDelay();
        Map map = loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"two", map.get("one"));
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        HashMap<String, String> map2 = new HashMap<String, String>(map);
        map2.put("five", "six");
        map2.put("seven", "eight");
        loader.put(fqn, map2);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"six", loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"eight", loader.get(fqn).get("seven"));
        AssertJUnit.assertEquals(map2, (Object)loader.get(fqn));
        AssertJUnit.assertEquals((int)4, (int)map2.size());
        AssertJUnit.assertTrue((boolean)loader.exists(fqn));
    }

    private void doRemoveTests(Fqn fqn) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        Object oldVal = loader.remove(fqn, (Object)"one");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = loader.remove(fqn, (Object)"five");
        AssertJUnit.assertEquals((Object)"six", (Object)oldVal);
        this.addDelay();
        AssertJUnit.assertEquals(null, loader.get(fqn).get("one"));
        AssertJUnit.assertEquals(null, loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"four", loader.get(fqn).get("three"));
        AssertJUnit.assertEquals((Object)"eight", loader.get(fqn).get("seven"));
        Map map = loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        AssertJUnit.assertEquals((Object)"eight", map.get("seven"));
        AssertJUnit.assertTrue((boolean)loader.exists(fqn));
        loader.remove(fqn);
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(fqn));
        AssertJUnit.assertTrue((!loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        Fqn k0;
        CacheLoader loader = this.loaderTL.get();
        AssertJUnit.assertTrue((!loader.exists(k0 = Fqn.fromString((String)"/key0")) ? 1 : 0) != 0);
        loader.put(Fqn.fromString((String)"/key0/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)loader.exists(k0));
        loader.put(Fqn.fromString((String)"/key0/x/y"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/x")));
        loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/x/y")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/x")));
        loader.remove(k0);
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(k0) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/x")) ? 1 : 0) != 0);
        loader.put(Fqn.fromString((String)"/key1"), null);
        loader.put(Fqn.fromString((String)"/key2"), null);
        loader.put(Fqn.fromString((String)"/key3"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        loader.put(Fqn.fromString((String)"/key3/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key1"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3")) ? 1 : 0) != 0);
        loader.remove(Fqn.fromString((String)"/key2"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(k0) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3")) ? 1 : 0) != 0);
        AssertJUnit.assertNull((Object)loader.get(k0));
        loader.put(Fqn.fromString((String)"/key0/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)loader.get(Fqn.fromString((String)"/key0/level1")).isEmpty());
        AssertJUnit.assertNotNull((Object)loader.get(k0));
        AssertJUnit.assertTrue((boolean)loader.get(Fqn.fromString((String)"/key0")).isEmpty());
        loader.put(Fqn.fromString((String)"/key0/x/y"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertTrue((boolean)loader.get(Fqn.fromString((String)"/key0/x")).isEmpty());
        loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertTrue((boolean)loader.get(Fqn.fromString((String)"/key0/x")).isEmpty());
        loader.remove(k0);
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(k0));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/x")));
        loader.put(Fqn.fromString((String)"/key1"), (Object)"a", (Object)"b");
        loader.put(Fqn.fromString((String)"/key2"), (Object)"a", (Object)"b");
        loader.put(Fqn.fromString((String)"/key3"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        loader.put(Fqn.fromString((String)"/key3/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)loader.get(Fqn.fromString((String)"/key3/level1")).isEmpty());
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key1"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3"));
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key2"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(k0));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3")));
    }

    public void testGetChildrenNames() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        this.checkChildren(Fqn.ROOT, null);
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        loader.put(Fqn.fromString((String)"/key0"), null);
        this.addDelay();
        this.checkChildren(Fqn.ROOT, new String[]{"key0"});
        loader.put(Fqn.fromString((String)"/key1/x"), null);
        this.addDelay();
        this.checkChildren(Fqn.ROOT, new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key1"), new String[]{"x"});
        loader.remove(Fqn.fromString((String)"/key1/x"));
        this.addDelay();
        this.checkChildren(Fqn.ROOT, new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        this.checkChildren(Fqn.fromString((String)"/key1"), null);
        loader.put(Fqn.fromString((String)"/key0/a"), null);
        loader.put(Fqn.fromString((String)"/key0/ab"), null);
        loader.put(Fqn.fromString((String)"/key0/abc"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc"});
        loader.put(Fqn.fromString((String)"/key0/xxx"), null);
        loader.put(Fqn.fromString((String)"/key0/xx"), null);
        loader.put(Fqn.fromString((String)"/key0/x"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        loader.put(Fqn.fromString((String)"/key0/a/1"), null);
        loader.put(Fqn.fromString((String)"/key0/a/2"), null);
        loader.put(Fqn.fromString((String)"/key0/a/2/1"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0/a/2"), new String[]{"1"});
        this.checkChildren(Fqn.fromString((String)"/key0/a"), new String[]{"1", "2"});
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
    }

    private void checkChildren(Fqn fqn, String[] names) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        Set set = loader.getChildrenNames(fqn);
        if (names != null) {
            AssertJUnit.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                AssertJUnit.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            AssertJUnit.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications();
    }

    public void testModificationsTransactional() throws Exception {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        this.doTestModifications();
        mgr.commit();
    }

    private void doTestModifications() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        List<Modification> list = this.createUpdates();
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        list.add(mod);
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_NODE);
        mod.setFqn(FQN);
        list.add(mod);
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        AssertJUnit.assertEquals(null, (Object)loader.get(FQN));
        loader.put(FQN, (Object)"one", (Object)"two");
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_DATA);
        mod.setFqn(FQN);
        list.add(mod);
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
    }

    public void testOnePhaseTransaction() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        List<Modification> mods = this.createUpdates();
        loader.prepare(null, mods, true);
        this.checkModifications(mods);
    }

    public void testTwoPhaseTransactionPassivation() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        loader.prepare(txnKey, mods, false);
        loader.commit(txnKey);
        this.addDelay();
        this.checkModifications(mods);
    }

    public void testTransactionRollbackPassivation() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        loader.remove(Fqn.fromString((String)"/"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        int num = baos.size();
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        loader.prepare(txnKey, mods, false);
        loader.rollback(txnKey);
        baos = new ByteArrayOutputStream(1024);
        os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadEntireState((ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertEquals((int)num, (int)baos.size());
    }

    private List<Modification> createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("five", "six");
        map.put("seven", "eight");
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_DATA);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        mod.setValue((Object)"two");
        list.add(mod);
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"three");
        mod.setValue((Object)"four");
        list.add(mod);
        return list;
    }

    private void checkModifications(List<Modification> list) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        block7: for (Modification mod : list) {
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case PUT_KEY_VALUE: {
                    AssertJUnit.assertEquals((Object)mod.getValue(), loader.get(fqn).get(mod.getKey()));
                    break;
                }
                case PUT_DATA: {
                    for (Object key : mod.getData().keySet()) {
                        AssertJUnit.assertEquals(mod.getData().get(key), loader.get(fqn).get(key));
                    }
                    continue block7;
                }
                case REMOVE_KEY_VALUE: {
                    AssertJUnit.assertEquals(null, loader.get(fqn).get(mod.getKey()));
                    break;
                }
                case REMOVE_DATA: {
                    Map map = loader.get(fqn);
                    AssertJUnit.assertNotNull((Object)map);
                    AssertJUnit.assertTrue((boolean)map.isEmpty());
                    break;
                }
                case REMOVE_NODE: {
                    AssertJUnit.assertEquals(null, (Object)loader.get(fqn));
                    break;
                }
                default: {
                    AssertJUnit.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testNullKeysAndValues() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        loader.put(FQN, null, (Object)"x");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"x", loader.get(FQN).get(null));
        HashMap<String, String> map = loader.get(FQN);
        AssertJUnit.assertEquals((int)1, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        loader.put(FQN, (Object)"y", null);
        this.addDelay();
        AssertJUnit.assertEquals(null, loader.get(FQN).get("y"));
        map = loader.get(FQN);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        AssertJUnit.assertEquals(null, map.get("y"));
        loader.remove(FQN, null);
        this.addDelay();
        AssertJUnit.assertEquals(null, loader.get(FQN).get(null));
        AssertJUnit.assertEquals((int)1, (int)loader.get(FQN).size());
        loader.remove(FQN, (Object)"y");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(FQN));
        AssertJUnit.assertNull(loader.get(FQN).get("y"));
        AssertJUnit.assertEquals((int)0, (int)loader.get(FQN).size());
        map = new HashMap<String, String>();
        map.put(null, null);
        loader.put(FQN, map);
        this.addDelay();
        AssertJUnit.assertEquals(map, (Object)loader.get(FQN));
        loader.remove(FQN);
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(FQN));
        map = new HashMap();
        map.put("xyz", null);
        map.put(null, "abc");
        loader.put(FQN, map);
        this.addDelay();
        AssertJUnit.assertEquals(map, (Object)loader.get(FQN));
        loader.remove(FQN);
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(FQN));
    }

    public void testDatabaseNamePassivation() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        loader.put(FQN, (Object)"one", (Object)"two");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", loader.get(FQN).get("one"));
    }

    public void testLoadAndStore() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        loader.remove(Fqn.fromString((String)"/"));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        loader.put(FQN, (Object)1, (Object)c1);
        loader.put(FQN, (Object)2, (Object)c2);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadEntireState((ObjectOutputStream)os);
        cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        byte[] savedState = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(savedState);
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        loader.storeEntireState((ObjectInputStream)is);
        is.close();
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
    }

    private static class Complex
    implements Serializable {
        private static final long serialVersionUID = 8950692199236424832L;
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            try {
                Complex x = (Complex)o;
                return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            if (this.nested == null) {
                return super.hashCode();
            }
            return 13 + this.nested.hashCode();
        }
    }
}

