/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true, testName="transaction.IsolationLevelReadCommittedTest")
public class IsolationLevelReadCommittedTest {
    private Cache<String, String> cache = null;
    private final Fqn FQN = Fqn.fromString((String)"/a/b/c");
    private final Fqn PARENT_FQN = this.FQN.getParent();
    private final String KEY = "key";
    private final String VALUE = "value";
    private volatile boolean writerFailed;
    private volatile boolean readerFailed;
    private volatile AssertionError writerError;
    private volatile AssertionError readerError;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.writerFailed = false;
        this.readerFailed = false;
        this.writerError = null;
        this.readerError = null;
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        config.setLockAcquisitionTimeout(1000L);
        config.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = instance.createCache(config);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testReadCommitted() throws Exception {
        final CountDownLatch readerCanRead = new CountDownLatch(1);
        final CountDownLatch readerDone = new CountDownLatch(1);
        final CountDownLatch writerCanWrite = new CountDownLatch(1);
        final CountDownLatch writerCanRollback = new CountDownLatch(1);
        final CountDownLatch writerDone = new CountDownLatch(1);
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        Thread readerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block16: {
                    TransactionManager tm;
                    block15: {
                        tm = null;
                        tm = IsolationLevelReadCommittedTest.this.startTransaction();
                        AssertJUnit.assertEquals((String)"Could not read node with expected value!", (String)"value", (String)((String)IsolationLevelReadCommittedTest.this.cache.get(IsolationLevelReadCommittedTest.this.FQN, (Object)"key")));
                        writerCanWrite.countDown();
                        readerCanRead.await();
                        try {
                            AssertJUnit.assertEquals((String)"thread w/ read lock can see subsequent uncommitted changes!!", (String)"value", (String)((String)IsolationLevelReadCommittedTest.this.cache.get(IsolationLevelReadCommittedTest.this.FQN, (Object)"key")));
                        }
                        catch (TimeoutException good) {
                            // empty catch block
                        }
                        writerCanRollback.countDown();
                        AssertJUnit.assertEquals((String)"Could not read node with expected value!", (String)"value", (String)((String)IsolationLevelReadCommittedTest.this.cache.get(IsolationLevelReadCommittedTest.this.FQN, (Object)"key")));
                        Object var4_5 = null;
                        System.out.println("reader thread exits");
                        if (tm == null) break block15;
                        try {
                            tm.commit();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    writerCanWrite.countDown();
                    writerCanRollback.countDown();
                    readerDone.countDown();
                    {
                        break block16;
                        catch (AssertionError e) {
                            IsolationLevelReadCommittedTest.this.readerError = e;
                            Object var4_6 = null;
                            System.out.println("reader thread exits");
                            if (tm != null) {
                                try {
                                    tm.commit();
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                            }
                            writerCanWrite.countDown();
                            writerCanRollback.countDown();
                            readerDone.countDown();
                            break block16;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            IsolationLevelReadCommittedTest.this.readerFailed = true;
                            Object var4_7 = null;
                            System.out.println("reader thread exits");
                            if (tm != null) {
                                try {
                                    tm.commit();
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                            }
                            writerCanWrite.countDown();
                            writerCanRollback.countDown();
                            readerDone.countDown();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        System.out.println("reader thread exits");
                        if (tm != null) {
                            try {
                                tm.commit();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        writerCanWrite.countDown();
                        writerCanRollback.countDown();
                        readerDone.countDown();
                        throw throwable;
                    }
                }
            }
        }, "READER");
        readerThread.start();
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        try {
                            writerCanWrite.await(3L, TimeUnit.SECONDS);
                            TransactionManager tm = IsolationLevelReadCommittedTest.this.startTransaction();
                            IsolationLevelReadCommittedTest.this.cache.put(IsolationLevelReadCommittedTest.this.FQN, (Object)"key", (Object)"this-shouldnt-be-visible");
                            readerCanRead.countDown();
                            writerCanWrite.await(3L, TimeUnit.SECONDS);
                            System.out.println("rolling back");
                            tm.rollback();
                        }
                        catch (AssertionError e) {
                            IsolationLevelReadCommittedTest.this.writerError = e;
                            Object var3_5 = null;
                            System.out.println("writer thread exits");
                            readerCanRead.countDown();
                            writerDone.countDown();
                            break block5;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            IsolationLevelReadCommittedTest.this.writerFailed = true;
                            Object var3_6 = null;
                            System.out.println("writer thread exits");
                            readerCanRead.countDown();
                            writerDone.countDown();
                        }
                        Object var3_4 = null;
                        System.out.println("writer thread exits");
                        readerCanRead.countDown();
                        writerDone.countDown();
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        System.out.println("writer thread exits");
                        readerCanRead.countDown();
                        writerDone.countDown();
                        throw throwable;
                    }
                }
            }
        }, "WRITER");
        writerThread.start();
        readerDone.await();
        writerDone.await();
        if (this.readerError != null) {
            throw this.readerError;
        }
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.readerFailed) {
            AssertJUnit.fail((String)"The reader thread exited incorrectly. Watch the log for previous stack traces");
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The writer thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeRemoved() throws Exception {
        final CountDownLatch readerCanRead = new CountDownLatch(1);
        final CountDownLatch readerDone = new CountDownLatch(1);
        final CountDownLatch writerDone = new CountDownLatch(1);
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        try {
                            TransactionManager mgr = IsolationLevelReadCommittedTest.this.startTransaction();
                            IsolationLevelReadCommittedTest.this.cache.removeNode(IsolationLevelReadCommittedTest.this.PARENT_FQN);
                            readerCanRead.countDown();
                            readerDone.await();
                            mgr.commit();
                        }
                        catch (AssertionError e) {
                            IsolationLevelReadCommittedTest.this.writerError = e;
                            Object var3_5 = null;
                            System.out.println("writer thread exits");
                            readerCanRead.countDown();
                            writerDone.countDown();
                            break block5;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            IsolationLevelReadCommittedTest.this.writerFailed = true;
                            Object var3_6 = null;
                            System.out.println("writer thread exits");
                            readerCanRead.countDown();
                            writerDone.countDown();
                        }
                        Object var3_4 = null;
                        System.out.println("writer thread exits");
                        readerCanRead.countDown();
                        writerDone.countDown();
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        System.out.println("writer thread exits");
                        readerCanRead.countDown();
                        writerDone.countDown();
                        throw throwable;
                    }
                }
            }
        }, "WRITER");
        writerThread.start();
        try {
            try {
                readerCanRead.await();
                AssertJUnit.assertEquals((String)"2nd thread cannot see uncommitted changes", (String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
            }
            catch (TimeoutException t) {
                Object var7_6 = null;
                System.out.println("reader thread exits");
                readerDone.countDown();
            }
            Object var7_5 = null;
            System.out.println("reader thread exits");
            readerDone.countDown();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            System.out.println("reader thread exits");
            readerDone.countDown();
            throw throwable;
        }
        writerDone.await();
        AssertJUnit.assertNull((String)"Node was removed", (Object)this.cache.getNode(this.FQN));
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The writer thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

