/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.concurrent.CountDownLatch;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true, testName="transaction.IsolationLevelSerializableTest")
public class IsolationLevelSerializableTest {
    private Cache<String, String> cache = null;
    private final Fqn FQN = Fqn.fromString((String)"/a");
    private final String KEY = "key";
    private final String VALUE = "value";
    private volatile boolean writerFailed;
    private volatile AssertionError writerError;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.writerFailed = false;
        this.writerError = null;
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        config.setLockAcquisitionTimeout(1000L);
        config.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = instance.createCache(config);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeRemoved() throws Exception {
        final CountDownLatch readerCanRead = new CountDownLatch(1);
        final CountDownLatch readerDone = new CountDownLatch(1);
        final CountDownLatch writerDone = new CountDownLatch(1);
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        Thread writerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        try {
                            TransactionManager tx = IsolationLevelSerializableTest.this.startTransaction();
                            IsolationLevelSerializableTest.this.cache.removeNode(IsolationLevelSerializableTest.this.FQN);
                            readerCanRead.countDown();
                            readerDone.await();
                            tx.commit();
                        }
                        catch (AssertionError e) {
                            IsolationLevelSerializableTest.this.writerError = e;
                            Object var3_5 = null;
                            System.out.println("writer thread exits");
                            readerCanRead.countDown();
                            writerDone.countDown();
                            break block5;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            IsolationLevelSerializableTest.this.writerFailed = true;
                            Object var3_6 = null;
                            System.out.println("writer thread exits");
                            readerCanRead.countDown();
                            writerDone.countDown();
                        }
                        Object var3_4 = null;
                        System.out.println("writer thread exits");
                        readerCanRead.countDown();
                        writerDone.countDown();
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        System.out.println("writer thread exits");
                        readerCanRead.countDown();
                        writerDone.countDown();
                        throw throwable;
                    }
                }
            }
        }, "WRITER");
        writerThread.start();
        try {
            try {
                readerCanRead.await();
                AssertJUnit.assertEquals((String)"2nd thread cannot see uncommitted changes", (String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
            }
            catch (TimeoutException good) {
                Object var7_6 = null;
                System.out.println("reader thread exits");
                readerDone.countDown();
            }
            Object var7_5 = null;
            System.out.println("reader thread exits");
            readerDone.countDown();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            System.out.println("reader thread exits");
            readerDone.countDown();
            throw throwable;
        }
        writerDone.await();
        AssertJUnit.assertNull((String)"Node was removed", (Object)this.cache.getNode(this.FQN));
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The writer thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

