/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.pessimistic;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true, testName="transaction.pessimistic.IsolationLevelNoneTest")
public class IsolationLevelNoneTest {
    CacheSPI<String, String> cache = null;
    final Fqn FQN = Fqn.fromString((String)"/a/b/c");
    final String KEY = "key";
    final String VALUE = "value";
    TransactionManager tm;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    public void testWithoutTransactions() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.NONE);
        this.cache.start();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.put(this.FQN + "/d", (Object)"key", (Object)"value");
        NodeSPI node = this.cache.peek(this.FQN, false, false);
        AssertJUnit.assertTrue((node != null && node.getKeys().contains("key") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testWithTransactions() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.NONE);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.tm = this.startTransaction();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.put(this.FQN + "/d", (Object)"key", (Object)"value");
        NodeSPI node = this.cache.peek(this.FQN, false, false);
        AssertJUnit.assertTrue((node != null && node.getKeys().contains("key") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.commit();
    }

    public void testWithTransactionsRepeatableRead() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.start();
        this.tm = this.startTransaction();
        this.cache.put(this.FQN, (Object)"key", (Object)"value");
        this.cache.put(this.FQN + "/d", (Object)"key", (Object)"value");
        NodeSPI node = this.cache.peek(this.FQN, false, false);
        AssertJUnit.assertTrue((node != null && node.getKeys().contains("key") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache.get(this.FQN, (Object)"key")));
        AssertJUnit.assertEquals((int)5, (int)this.cache.getNumberOfLocksHeld());
        this.tm.commit();
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

