/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.pessimistic;

import java.util.LinkedList;
import java.util.Set;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.DummyBaseTransactionManager;
import org.jboss.cache.transaction.DummyTransaction;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.TransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="transaction.pessimistic.StatusUnknownTest")
public class StatusUnknownTest {
    private Cache<String, String> cache;
    private TransactionManager tm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(HeuristicFailingDummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
        this.tm = null;
    }

    public void testStatusUnknown() throws Exception {
        this.tm.begin();
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        this.cache.put(fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)4, (int)((CacheSPI)this.cache).getNumberOfLocksHeld());
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(fqn));
        this.tm.commit();
        AssertJUnit.assertEquals((int)0, (int)((CacheSPI)this.cache).getNumberOfLocksHeld());
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(fqn));
    }

    public static class HeuristicFailingDummyTransactionManagerLookup
    implements TransactionManagerLookup {
        public TransactionManager getTransactionManager() throws Exception {
            return HeuristicFailingDummyTransactionManager.getInstance();
        }
    }

    public static class HeuristicFailingDummyTransaction
    extends DummyTransaction {
        public HeuristicFailingDummyTransaction(DummyBaseTransactionManager mgr) {
            super(mgr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() throws RollbackException {
            try {
                this.notifyBeforeCompletion();
                this.notifyAfterCompletion(5);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.tm_.setTransaction(null);
                throw throwable;
            }
            this.tm_.setTransaction(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyAfterCompletion(int status) {
            LinkedList tmp;
            Set set = this.participants;
            synchronized (set) {
                tmp = new LinkedList(this.participants);
            }
            for (Synchronization s : tmp) {
                try {
                    s.afterCompletion(status);
                }
                catch (Throwable t) {
                    throw (RuntimeException)t;
                }
            }
            set = this.participants;
            synchronized (set) {
                this.participants.clear();
            }
        }
    }

    public static class HeuristicFailingDummyTransactionManager
    extends DummyTransactionManager {
        private static final long serialVersionUID = 6325631394461739211L;
        private static DummyTransactionManager instance;

        public void begin() throws SystemException, NotSupportedException {
            super.begin();
            HeuristicFailingDummyTransaction tx = new HeuristicFailingDummyTransaction((DummyBaseTransactionManager)this);
            this.setTransaction((Transaction)tx);
        }

        public static DummyTransactionManager getInstance() {
            if (instance == null) {
                instance = new HeuristicFailingDummyTransactionManager();
            }
            return instance;
        }
    }
}

