/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jboss.cache.util.Immutables;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="util.ImmutableListCopyTest")
public class ImmutableListCopyTest {
    public void testImmutability() {
        List l = Immutables.immutableListCopy(Collections.singletonList("one"));
        try {
            l.add("two");
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.remove(0);
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.clear();
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.add(0, "x");
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.set(0, "i");
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.addAll(Collections.singletonList("l"));
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.addAll(0, Collections.singletonList("l"));
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.removeAll(Collections.singletonList("l"));
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.retainAll(Collections.singletonList("l"));
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.iterator().remove();
            assert (false);
        }
        catch (UnsupportedOperationException good) {
            // empty catch block
        }
        try {
            l.listIterator().set("w");
            assert (false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testListIterator() {
        List list = Immutables.immutableListWrap((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ListIterator li = list.listIterator();
        int number = 1;
        while (li.hasNext()) {
            assert ((Integer)li.next() == number++);
        }
        assert (number == 11);
        number = 10;
        li = list.listIterator(list.size());
        while (li.hasPrevious()) {
            assert ((Integer)li.previous() == number--);
        }
        assert (number == 0);
    }

    public void testSubLists() {
        List<Integer> ints = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        List list = Immutables.immutableListCopy(ints);
        assert (((Object)ints.subList(2, 5)).equals(list.subList(2, 5)));
        assert (((Object)ints.subList(1, 9)).equals(list.subList(1, 9)));
        assert (((Object)ints.subList(0, 1)).equals(list.subList(0, 1)));
    }

    static Object copy(Object o) throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        new ObjectOutputStream(bo).writeObject(o);
        ByteArrayInputStream is = new ByteArrayInputStream(bo.toByteArray());
        return new ObjectInputStream(is).readObject();
    }

    public void testSerialization() throws Exception {
        List<Integer> ints = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        ImmutableListCopyTest.copy(Immutables.immutableListCopy(ints));
    }
}

