/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import org.testng.IClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class UnitTestTestNGListener
implements ITestListener {
    private ThreadLocal<IClass> threadTestClass = new ThreadLocal();
    private int failed = 0;
    private int succeded = 0;
    private int skipped = 0;

    public void onTestStart(ITestResult res) {
        System.out.println(this.getThreadId() + " Starting test " + this.getTestDesc(res));
        this.threadTestClass.set(res.getTestClass());
    }

    public synchronized void onTestSuccess(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " succeded.");
        ++this.succeded;
        this.printStatus();
    }

    public synchronized void onTestFailure(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " failed.");
        ++this.failed;
        this.printStatus();
    }

    public synchronized void onTestSkipped(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " skipped.");
        ++this.skipped;
        this.printStatus();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onStart(ITestContext arg0) {
    }

    public void onFinish(ITestContext arg0) {
    }

    private String getThreadId() {
        return "[" + Thread.currentThread().getName() + "]";
    }

    private String getTestDesc(ITestResult res) {
        return res.getMethod().getMethodName() + "(" + res.getTestClass().getName() + ")";
    }

    private void printStatus() {
        System.out.println("Testsuite execution progress: tests succeded " + this.succeded + ", failed " + this.failed + ", skipped " + this.skipped + ".");
    }
}

