/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.pojo.rollback;

import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertNull;
import static org.testng.AssertJUnit.assertTrue;

import java.util.ArrayList;

import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.impl.InternalConstant;
import org.jboss.cache.pojo.interceptors.dynamic.CacheFieldInterceptor;
import org.jboss.cache.pojo.test.Person;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Additional basic tests
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class LocalExceptionUndoTest
{
   Log log_ = LogFactory.getLog(LocalExceptionUndoTest.class);
   PojoCache cache_;
   TransactionManager tx_mgr;
   boolean isTrue = false;

   @BeforeMethod(alwaysRun = true)
   public void setUp() throws Exception
   {
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.getCache().getConfiguration().setLockAcquisitionTimeout(500); // timeout to 500 ms
      cache_.getCache().getConfiguration().setLockParentForChildInsertRemove(true); // test written to expect this
      cache_.start();
      tx_mgr = DummyTransactionManager.getInstance();
   }

   private void startLockThread() throws Exception
   {
      isTrue = false;
      // Lock thread to lock underlying node.
      (new LockThread()).start();
      Thread.sleep(300);
   }

   private void stopLockThread() throws Exception
   {
      isTrue = true;
      Thread.sleep(200);
   }

   @AfterMethod(alwaysRun = true)
   public void tearDown() throws Exception
   {
      cache_.stop();
   }

   public void testSimpleTxWithRollback1() throws Exception
   {
      log_.info("testSimpleTxWithRollback1() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      ArrayList<String> list = new ArrayList<String>();
      list.add("English");
      test.setLanguages(list);

      startLockThread();

      try
      {
         cache_.attach("/a", test);
      }
      catch (PojoCacheException ex)
      {
//         ex.printStackTrace();
      }
      assertFalse("Should not have cache interceptor ", hasCacheInterceptor(test));
      assertNull("Should be null", cache_.find("/a"));

      stopLockThread();
      cache_.attach("/a", test);
   }

   public void testSimpleTxWithRollback2() throws Exception
   {
      log_.info("testSimpleTxWithRollback1() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      ArrayList<String> list = new ArrayList<String>();
      list.add("English");
      test.setLanguages(list);

      try
      {
         cache_.attach("/a", test);
      }
      catch (PojoCacheException ex)
      {
//         ex.printStackTrace();
      }

      startLockThread();

      try
      {
         cache_.detach("/a");
      }
      catch (PojoCacheException ex)
      {
//         ex.printStackTrace();
      }

      stopLockThread();
      assertTrue("Should still have cache interceptor ", hasCacheInterceptor(test));
      cache_.detach("/a");
      assertNull("Should be null", cache_.find("/a"));
   }

   private boolean hasCacheInterceptor(Object pojo)
   {
      Interceptor[] interceptors = ((Advised) pojo)._getInstanceAdvisor().getInterceptors();
      for (int i = 0; i < interceptors.length; i++)
      {
         if (interceptors[i] instanceof CacheFieldInterceptor)
            return true;
      }
      return false;
   }

   public class LockThread extends Thread
   {
      public void run()
      {
         try
         {
            Fqn<String> f = new Fqn<String>(InternalConstant.JBOSS_INTERNAL_STRING);
            tx_mgr.begin();
            cache_.getCache().put(new Fqn<String>(f, "123"), "key", "test");
            cache_.getCache().put(new Fqn<String>("a"), "key", "test");
            cache_.getCache().put(new Fqn<String>(f, "124"), "key", "test");

            while (!isTrue)
            {
               sleep(100);
            }
            tx_mgr.commit();
         }
         catch (Exception ex)
         {
            ex.printStackTrace();
         }

      }
   }
}
