/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.hibernate.HibernateException;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.ChainedFilter;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.query.FullTextFilterImpl;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.transform.ResultTransformer;
import org.jboss.cache.Cache;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.CacheEntityLoader;
import org.jboss.cache.search.CacheQuery;
import org.jboss.cache.search.QueryResultIterator;
import org.jboss.cache.search.QueryResultIteratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheQueryImpl
implements CacheQuery {
    private Class[] classes;
    private Sort sort;
    private Filter filter;
    private Map<String, FullTextFilterImpl> filterDefinitions;
    private SearchFactoryImplementor searchFactory;
    private Integer firstResult;
    private Integer resultSize;
    private Integer maxResults;
    private static final Log log = LogFactory.getLog(CacheQueryImpl.class);
    private Set<Class> classesAndSubclasses;
    private boolean needClassFilterClause;
    private Query luceneQuery;
    private int fetchSize;
    private String[] indexProjection;
    private ResultTransformer resultTransformer;
    CacheEntityLoader entityLoader;

    public CacheQueryImpl(Query luceneQuery, SearchFactoryImplementor searchFactory, Cache cache) {
        this.luceneQuery = luceneQuery;
        this.entityLoader = new CacheEntityLoader(cache);
        this.searchFactory = searchFactory;
    }

    public CacheQueryImpl(Query luceneQuery, SearchFactoryImplementor searchFactory, Cache cache, Class ... classes) {
        this(luceneQuery, searchFactory, cache);
        this.classes = classes;
    }

    @Override
    public void setFilter(Filter f) {
        this.filter = f;
    }

    @Override
    public int getResultSize() {
        if (this.resultSize == null) {
            IndexSearcher searcher = this.buildSearcher(this.searchFactory);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    Hits hits = this.getHits((Searcher)searcher);
                    this.resultSize = hits.length();
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to query Lucene index", (Throwable)e);
                }
                finally {
                    try {
                        this.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
                    }
                    catch (SearchException e) {
                        log.warn((Object)("Unable to properly close searcher during lucene query: " + (Object)((Object)e)));
                    }
                }
            }
        }
        return this.resultSize;
    }

    @Override
    public void setSort(Sort s) {
        this.sort = s;
    }

    private void closeSearcher(Searcher searcher, ReaderProvider readerProvider) {
        Set indexReaders = ReaderProviderHelper.getIndexReaders((Searchable)searcher);
        for (IndexReader indexReader : indexReaders) {
            readerProvider.closeReader(indexReader);
        }
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        FullTextFilterImpl filterDefinition;
        if (this.filterDefinitions == null) {
            this.filterDefinitions = new HashMap<String, FullTextFilterImpl>();
        }
        if ((filterDefinition = this.filterDefinitions.get(name)) != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.searchFactory.getFilterDefinition(name);
        if (filterDef == null) {
            throw new SearchException("Unkown @FullTextFilter: " + name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.filterDefinitions.remove(name);
    }

    @Override
    public void setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
    }

    @Override
    public QueryResultIterator iterator() throws HibernateException {
        ArrayList<CacheEntityId> ids = null;
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        if (searcher == null) {
            throw new NullPointerException("IndexSearcher instance is null.");
        }
        try {
            Hits hits = this.getHits((Searcher)searcher);
            int first = this.first();
            int max = this.max(first, hits);
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ids = new ArrayList<CacheEntityId>(size);
            DocumentExtractor extractor = new DocumentExtractor(this.luceneQuery, searcher, this.searchFactory, this.indexProjection);
            for (int index = first; index <= max; ++index) {
                String documentId = (String)((Object)extractor.extract((Hits)hits, (int)index).id);
                CacheEntityId id = new CacheEntityId(documentId);
                ids.add(id);
            }
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            this.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
        }
        return new QueryResultIteratorImpl(ids, this.entityLoader);
    }

    @Override
    public List<Object> list() throws HibernateException {
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        if (searcher == null) {
            return new ArrayList<Object>(0);
        }
        try {
            List list;
            int first;
            int max;
            Hits hits = this.getHits((Searcher)searcher);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Number of hits are " + hits.length()));
            }
            int size = (max = this.max(first = this.first(), hits)) - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<CacheEntityId> ids = new ArrayList<CacheEntityId>(size);
            DocumentExtractor extractor = new DocumentExtractor(this.luceneQuery, searcher, this.searchFactory, this.indexProjection);
            for (int index = first; index <= max; ++index) {
                String documentId = (String)((Object)extractor.extract((Hits)hits, (int)index).id);
                CacheEntityId id = new CacheEntityId(documentId);
                ids.add(id);
            }
            List list2 = this.entityLoader.load(ids);
            if (this.resultTransformer == null) {
                list = list2;
                return list;
            }
            list = this.resultTransformer.transformList(list2);
            return list;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            this.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
        }
    }

    private int max(int first, Hits hits) {
        return this.maxResults == null ? hits.length() - 1 : (this.maxResults + first < hits.length() ? first + this.maxResults - 1 : hits.length() - 1);
    }

    private int first() {
        return this.firstResult != null ? this.firstResult : 0;
    }

    @Override
    public void setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("'fetch size' parameter less than or equals to 0");
        }
        this.fetchSize = fetchSize;
    }

    private IndexSearcher buildSearcher(SearchFactoryImplementor searchFactoryImplementor) {
        Map builders = searchFactoryImplementor.getDocumentBuilders();
        ArrayList<DirectoryProvider> directories = new ArrayList<DirectoryProvider>();
        Similarity searcherSimilarity = null;
        if (this.classes == null || this.classes.length == 0) {
            for (DocumentBuilder builder : builders.values()) {
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                DirectoryProvider[] directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards();
                this.populateDirectories(directories, directoryProviders);
            }
            this.classesAndSubclasses = null;
        } else {
            HashSet<Class> involvedClasses = new HashSet<Class>(this.classes.length);
            Collections.addAll(involvedClasses, this.classes);
            for (Class clazz : this.classes) {
                DocumentBuilder builder = (DocumentBuilder)builders.get(clazz);
                if (builder == null) continue;
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class clazz : involvedClasses) {
                DocumentBuilder builder = (DocumentBuilder)builders.get(clazz);
                if (builder == null) {
                    throw new HibernateException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                DirectoryProvider[] directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards();
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                this.populateDirectories(directories, directoryProviders);
            }
            this.classesAndSubclasses = involvedClasses;
        }
        if (this.classesAndSubclasses != null) {
            for (DirectoryProvider dp : directories) {
                Set classesInDirectoryProvider = searchFactoryImplementor.getClassesInDirectoryProvider(dp);
                if (classesInDirectoryProvider.size() > 1) {
                    for (Class clazz : classesInDirectoryProvider) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        }
        DirectoryProvider[] directoryProviders = directories.toArray(new DirectoryProvider[directories.size()]);
        IndexSearcher is = new IndexSearcher(searchFactoryImplementor.getReaderProvider().openReader(directoryProviders));
        is.setSimilarity(searcherSimilarity);
        return is;
    }

    private Similarity checkSimilarity(Similarity similarity, DocumentBuilder builder) {
        if (similarity == null) {
            similarity = builder.getSimilarity();
        } else if (!similarity.getClass().equals(builder.getSimilarity().getClass())) {
            throw new HibernateException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + builder.getSimilarity().getClass().getName() + ")");
        }
        return similarity;
    }

    private void populateDirectories(List<DirectoryProvider> directories, DirectoryProvider[] directoryProviders) {
        for (DirectoryProvider provider : directoryProviders) {
            if (directories.contains(provider)) continue;
            directories.add(provider);
        }
    }

    private Hits getHits(Searcher searcher) throws IOException {
        Query query = this.filterQueryByClasses(this.luceneQuery);
        this.buildFilters();
        Hits hits = searcher.search(query, this.filter, this.sort);
        this.setResultSize(hits);
        return hits;
    }

    private void setResultSize(Hits hits) {
        this.resultSize = hits.length();
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((Query)classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private void buildFilters() {
        if (this.filterDefinitions != null && this.filterDefinitions.size() > 0) {
            ChainedFilter chainedFilter = new ChainedFilter();
            for (FullTextFilterImpl filterDefinition : this.filterDefinitions.values()) {
                Filter filter;
                Object instance;
                FilterDef def = this.searchFactory.getFilterDefinition(filterDefinition.getName());
                Class implClass = def.getImpl();
                try {
                    instance = implClass.newInstance();
                }
                catch (Exception e) {
                    throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), (Throwable)e);
                }
                for (Map.Entry entry : filterDefinition.getParameters().entrySet()) {
                    def.invoke((String)entry.getKey(), instance, entry.getValue());
                }
                if (def.isCache() && def.getKeyMethod() == null && filterDefinition.getParameters().size() > 0) {
                    throw new SearchException("Filter with parameters and no @Key method: " + filterDefinition.getName());
                }
                FilterKey key = null;
                if (def.isCache()) {
                    if (def.getKeyMethod() == null) {
                        key = new FilterKey(){

                            public int hashCode() {
                                return this.getImpl().hashCode();
                            }

                            public boolean equals(Object obj) {
                                if (!(obj instanceof FilterKey)) {
                                    return false;
                                }
                                FilterKey that = (FilterKey)obj;
                                return this.getImpl().equals(that.getImpl());
                            }
                        };
                    } else {
                        try {
                            key = (FilterKey)def.getKeyMethod().invoke(instance, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
                        }
                        catch (InvocationTargetException e) {
                            throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
                        }
                        catch (ClassCastException e) {
                            throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
                        }
                    }
                    key.setImpl(def.getImpl());
                }
                Filter filter2 = filter = def.isCache() ? this.searchFactory.getFilterCachingStrategy().getCachedFilter(key) : null;
                if (filter == null) {
                    if (def.getFactoryMethod() != null) {
                        try {
                            filter = (Filter)def.getFactoryMethod().invoke(instance, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                        }
                        catch (InvocationTargetException e) {
                            throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                        }
                        catch (ClassCastException e) {
                            throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                        }
                    }
                    try {
                        filter = (Filter)instance;
                    }
                    catch (ClassCastException e) {
                        throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                    }
                    if (def.isCache()) {
                        this.searchFactory.getFilterCachingStrategy().addCachedFilter(key, filter);
                    }
                }
                chainedFilter.addFilter(filter);
            }
            if (this.filter != null) {
                chainedFilter.addFilter(this.filter);
            }
            this.filter = chainedFilter;
        }
    }
}

