/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.search.SearchableCache;
import org.jboss.cache.search.SearchableCacheCfgImpl;
import org.jboss.cache.search.SearchableCacheImpl;
import org.jboss.cache.search.SearchableCoreListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchableCacheFactory {
    private static final Log log = LogFactory.getLog(SearchableCacheFactory.class);

    public SearchableCache createSearchableCache(Cache<?, ?> c, Class ... classes) {
        return this.createSearchableCache(c, (Properties)null, classes);
    }

    public SearchableCache createSearchableCache(Cache<?, ?> c, Properties properties, Class ... classes) {
        this.validateClasses(classes);
        if (c.getCacheStatus() != CacheStatus.STARTED) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Cache not started.  Starting cache first.");
            }
            c.start();
        }
        if (classes.length == 0 && log.isWarnEnabled()) {
            log.warn((Object)"You haven't passed in any classes to index.  Is this an error?");
        }
        SearchableCacheCfgImpl cfg = new SearchableCacheCfgImpl(classes, properties);
        SearchFactoryImpl searchFactory = new SearchFactoryImpl((SearchConfiguration)cfg);
        SearchableCoreListener listener = new SearchableCoreListener((SearchFactoryImplementor)searchFactory);
        c.addCacheListener((Object)listener);
        SearchableCacheImpl sc = new SearchableCacheImpl(c, (SearchFactoryImplementor)searchFactory);
        return sc;
    }

    private void validateClasses(Class ... classes) {
        for (Class c : classes) {
            if (!c.isAnnotationPresent(ProvidedId.class)) {
                throw new IllegalArgumentException("There is no provided id on " + c.getName() + " class");
            }
            for (Field field : c.getFields()) {
                if (field.getAnnotation(DocumentId.class) == null) continue;
                throw new IllegalArgumentException("Please remove the documentId annotation in " + c.getName());
            }
        }
    }
}

