/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.store.DirectoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneWorker {
    private final Workspace workspace;
    private static final Logger log = LoggerFactory.getLogger(LuceneWorker.class);

    public LuceneWorker(Workspace workspace) {
        this.workspace = workspace;
    }

    public void performWork(WorkWithPayload luceneWork) {
        Class<?> workClass = luceneWork.getWork().getClass();
        if (AddLuceneWork.class.isAssignableFrom(workClass)) {
            this.performWork((AddLuceneWork)luceneWork.getWork(), luceneWork.getProvider());
        } else if (DeleteLuceneWork.class.isAssignableFrom(workClass)) {
            this.performWork((DeleteLuceneWork)luceneWork.getWork(), luceneWork.getProvider());
        } else if (OptimizeLuceneWork.class.isAssignableFrom(workClass)) {
            this.performWork((OptimizeLuceneWork)luceneWork.getWork(), luceneWork.getProvider());
        } else if (PurgeAllLuceneWork.class.isAssignableFrom(workClass)) {
            this.performWork((PurgeAllLuceneWork)luceneWork.getWork(), luceneWork.getProvider());
        } else {
            throw new AssertionFailure("Unknown work type: " + workClass);
        }
    }

    public void performWork(AddLuceneWork work, DirectoryProvider provider) {
        Class entity = work.getEntityClass();
        Serializable id = work.getId();
        Document document = work.getDocument();
        this.add(entity, id, document, provider);
    }

    private void add(Class entity, Serializable id, Document document, DirectoryProvider provider) {
        log.trace("add to Lucene index: {}#{}:{}", new Object[]{entity, id, document});
        IndexWriter writer = this.workspace.getIndexWriter(provider, entity, true);
        try {
            writer.addDocument(document);
        }
        catch (IOException e) {
            throw new SearchException("Unable to add to Lucene index: " + entity + "#" + id, e);
        }
    }

    public void performWork(DeleteLuceneWork work, DirectoryProvider provider) {
        Class entity = work.getEntityClass();
        Serializable id = work.getId();
        this.remove(entity, id, provider);
    }

    private void remove(Class entity, Serializable id, DirectoryProvider provider) {
        log.trace("remove from Lucene index: {}#{}", (Object)entity, (Object)id);
        DocumentBuilder builder = this.workspace.getDocumentBuilder(entity);
        Term term = builder.getTerm(id);
        IndexReader reader = this.workspace.getIndexReader(provider, entity);
        TermDocs termDocs = null;
        try {
            termDocs = reader.termDocs(term);
            String entityName = entity.getName();
            while (termDocs.next()) {
                int docIndex = termDocs.doc();
                if (!entityName.equals(reader.document(docIndex).get("_hibernate_class"))) continue;
                reader.deleteDocument(docIndex);
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to remove from Lucene index: " + entity + "#" + id, e);
        }
        finally {
            if (termDocs != null) {
                try {
                    termDocs.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close termDocs properly", (Throwable)e);
                }
            }
        }
    }

    public void performWork(OptimizeLuceneWork work, DirectoryProvider provider) {
        Class entity = work.getEntityClass();
        log.trace("optimize Lucene index: {}", (Object)entity);
        IndexWriter writer = this.workspace.getIndexWriter(provider, entity, false);
        try {
            writer.optimize();
            this.workspace.optimize(provider);
        }
        catch (IOException e) {
            throw new SearchException("Unable to optimize Lucene index: " + entity, e);
        }
    }

    public void performWork(PurgeAllLuceneWork work, DirectoryProvider provider) {
        Class entity = work.getEntityClass();
        log.trace("purgeAll Lucene index: {}", (Object)entity);
        IndexReader reader = this.workspace.getIndexReader(provider, entity);
        try {
            Term term = new Term("_hibernate_class", entity.getName());
            reader.deleteDocuments(term);
        }
        catch (Exception e) {
            throw new SearchException("Unable to purge all from Lucene index: " + entity, e);
        }
    }

    public static class WorkWithPayload {
        private final LuceneWork work;
        private final DirectoryProvider provider;

        public WorkWithPayload(LuceneWork work, DirectoryProvider provider) {
            this.work = work;
            this.provider = provider;
        }

        public LuceneWork getWork() {
            return this.work;
        }

        public DirectoryProvider getProvider() {
            return this.provider;
        }
    }
}

