/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.InitContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.BinderHelper;
import org.hibernate.search.util.ScopedAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(DocumentBuilder.class);
    private final PropertiesMetadata rootPropertiesMetadata = new PropertiesMetadata();
    private final XClass beanClass;
    private final DirectoryProvider[] directoryProviders;
    private final IndexShardingStrategy shardingStrategy;
    private String idKeywordName;
    private XMember idGetter;
    private Float idBoost;
    public static final String CLASS_FIELDNAME = "_hibernate_class";
    private TwoWayFieldBridge idBridge;
    private Set<Class> mappedSubclasses = new HashSet<Class>();
    private ReflectionManager reflectionManager;
    private int level = 0;
    private int maxLevel = Integer.MAX_VALUE;
    private final ScopedAnalyzer analyzer = new ScopedAnalyzer();
    private Similarity similarity;
    private boolean isRoot;
    private boolean safeFromTupleId;
    private boolean idProvided = false;

    public boolean isRoot() {
        return this.isRoot;
    }

    public DocumentBuilder(XClass clazz, InitContext context, DirectoryProvider[] directoryProviders, IndexShardingStrategy shardingStrategy, ReflectionManager reflectionManager) {
        this.beanClass = clazz;
        this.directoryProviders = directoryProviders;
        this.shardingStrategy = shardingStrategy;
        this.reflectionManager = reflectionManager;
        this.similarity = context.getDefaultSimilarity();
        if (clazz == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilder with a null class");
        }
        this.rootPropertiesMetadata.boost = this.getBoost((XAnnotatedElement)clazz);
        this.rootPropertiesMetadata.analyzer = context.getDefaultAnalyzer();
        HashSet<XClass> processedClasses = new HashSet<XClass>();
        processedClasses.add(clazz);
        this.initializeMembers(clazz, this.rootPropertiesMetadata, true, "", processedClasses, context);
        this.analyzer.setGlobalAnalyzer(this.rootPropertiesMetadata.analyzer);
        if (this.idKeywordName == null) {
            ProvidedId provided = (ProvidedId)clazz.getAnnotation(ProvidedId.class);
            if (provided == null) {
                throw new SearchException("No document id in: " + clazz.getName());
            }
            this.idBridge = this.getProvidedIdBridge();
            this.idKeywordName = provided.name();
        }
        this.safeFromTupleId = TwoWayString2FieldBridgeAdaptor.class.isAssignableFrom(this.idBridge.getClass());
    }

    private TwoWayFieldBridge getProvidedIdBridge() {
        return new TwoWayString2FieldBridgeAdaptor(new StringBridge());
    }

    private Analyzer getAnalyzer(XAnnotatedElement annotatedElement, InitContext context) {
        org.hibernate.search.annotations.Analyzer analyzerAnn = (org.hibernate.search.annotations.Analyzer)annotatedElement.getAnnotation(org.hibernate.search.annotations.Analyzer.class);
        return this.getAnalyzer(analyzerAnn, context);
    }

    private Analyzer getAnalyzer(org.hibernate.search.annotations.Analyzer analyzerAnn, InitContext context) {
        Class analyzerClass;
        Class clazz = analyzerClass = analyzerAnn == null ? Void.TYPE : analyzerAnn.impl();
        if (analyzerClass == Void.TYPE) {
            String definition;
            String string = definition = analyzerAnn == null ? "" : analyzerAnn.definition();
            if (StringHelper.isEmpty((String)definition)) {
                return null;
            }
            return context.buildLazyAnalyzer(definition);
        }
        try {
            return (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    private void initializeMembers(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, InitContext context) {
        ArrayList<XClass> hierarchy = new ArrayList<XClass>();
        for (XClass currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            hierarchy.add(currClass);
        }
        Class similarityClass = null;
        for (int index = hierarchy.size() - 1; index >= 0; --index) {
            org.hibernate.search.annotations.Similarity similarityAnn;
            ClassBridge classBridgeAnn;
            XClass currClass = (XClass)hierarchy.get(index);
            Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)currClass, context);
            if (analyzer != null) {
                propertiesMetadata.analyzer = analyzer;
            }
            this.getAnalyzerDefs((XAnnotatedElement)currClass, context);
            ClassBridges classBridgesAnn = (ClassBridges)currClass.getAnnotation(ClassBridges.class);
            if (classBridgesAnn != null) {
                ClassBridge[] cbs;
                for (ClassBridge cb : cbs = classBridgesAnn.value()) {
                    this.bindClassAnnotation(prefix, propertiesMetadata, cb, context);
                }
            }
            if ((classBridgeAnn = (ClassBridge)currClass.getAnnotation(ClassBridge.class)) != null) {
                this.bindClassAnnotation(prefix, propertiesMetadata, classBridgeAnn, context);
            }
            if (isRoot && (similarityAnn = (org.hibernate.search.annotations.Similarity)currClass.getAnnotation(org.hibernate.search.annotations.Similarity.class)) != null) {
                if (similarityClass != null) {
                    throw new SearchException("Multiple Similarities defined in the same class hierarchy: " + this.beanClass.getName());
                }
                similarityClass = similarityAnn.impl();
            }
            List methods = currClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMember(method, propertiesMetadata, isRoot, prefix, processedClasses, context);
            }
            List fields = currClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMember(field, propertiesMetadata, isRoot, prefix, processedClasses, context);
            }
        }
        if (isRoot && similarityClass != null) {
            try {
                this.similarity = (Similarity)similarityClass.newInstance();
            }
            catch (Exception e) {
                log.error("Exception attempting to instantiate Similarity '{}' set for {}", (Object)similarityClass.getName(), (Object)this.beanClass.getName());
            }
        }
    }

    private void getAnalyzerDefs(XAnnotatedElement annotatedElement, InitContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def);
    }

    public String getIdentifierName() {
        return this.idGetter.getName();
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    private void initializeMember(XProperty member, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, InitContext context) {
        ContainedIn containedAnn;
        Fields fieldsAnn;
        org.hibernate.search.annotations.Field fieldAnn;
        DocumentId documentIdAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (documentIdAnn != null) {
            if (isRoot) {
                if (this.idKeywordName != null) {
                    throw new AssertionFailure("Two document id assigned: " + this.idKeywordName + " and " + BinderHelper.getAttributeName((XMember)member, documentIdAnn.name()));
                }
                this.idKeywordName = prefix + BinderHelper.getAttributeName((XMember)member, documentIdAnn.name());
                FieldBridge fieldBridge = BridgeFactory.guessType(null, (XMember)member, this.reflectionManager);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
                }
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
                this.idBoost = this.getBoost((XAnnotatedElement)member);
                DocumentBuilder.setAccessible((XMember)member);
                this.idGetter = member;
            } else {
                DocumentBuilder.setAccessible((XMember)member);
                propertiesMetadata.fieldGetters.add((XMember)member);
                String fieldName = prefix + BinderHelper.getAttributeName((XMember)member, documentIdAnn.name());
                propertiesMetadata.fieldNames.add(fieldName);
                propertiesMetadata.fieldStore.add(this.getStore(Store.YES));
                propertiesMetadata.fieldIndex.add(this.getIndex(Index.UN_TOKENIZED));
                propertiesMetadata.fieldTermVectors.add(this.getTermVector(TermVector.NO));
                propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(null, (XMember)member, this.reflectionManager));
                Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
                if (analyzer == null) {
                    analyzer = propertiesMetadata.analyzer;
                }
                if (analyzer == null) {
                    throw new AssertionFailure("Analizer should not be undefined");
                }
                this.analyzer.addScopedAnalyzer(fieldName, analyzer);
            }
        }
        if ((fieldAnn = (org.hibernate.search.annotations.Field)member.getAnnotation(org.hibernate.search.annotations.Field.class)) != null) {
            this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn, context);
        }
        if ((fieldsAnn = (Fields)member.getAnnotation(Fields.class)) != null) {
            for (org.hibernate.search.annotations.Field fieldAnn2 : fieldsAnn.value()) {
                this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn2, context);
            }
        }
        this.getAnalyzerDefs((XAnnotatedElement)member, context);
        IndexedEmbedded embeddedAnn = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (embeddedAnn != null) {
            int oldMaxLevel = this.maxLevel;
            int potentialLevel = embeddedAnn.depth() + this.level;
            if (potentialLevel < 0) {
                potentialLevel = Integer.MAX_VALUE;
            }
            this.maxLevel = potentialLevel > this.maxLevel ? this.maxLevel : potentialLevel;
            ++this.level;
            XClass elementClass = Void.TYPE == embeddedAnn.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(embeddedAnn.targetElement());
            if (this.maxLevel == Integer.MAX_VALUE && processedClasses.contains(elementClass)) {
                throw new SearchException("Circular reference. Duplicate use of " + elementClass.getName() + " in root entity " + this.beanClass.getName() + "#" + this.buildEmbeddedPrefix(prefix, embeddedAnn, member));
            }
            if (this.level <= this.maxLevel) {
                processedClasses.add(elementClass);
                DocumentBuilder.setAccessible((XMember)member);
                propertiesMetadata.embeddedGetters.add((XMember)member);
                PropertiesMetadata metadata = new PropertiesMetadata();
                propertiesMetadata.embeddedPropertiesMetadata.add(metadata);
                metadata.boost = this.getBoost((XAnnotatedElement)member);
                Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
                metadata.analyzer = analyzer != null ? analyzer : propertiesMetadata.analyzer;
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                this.initializeMembers(elementClass, metadata, false, localPrefix, processedClasses, context);
                if (member.isArray()) {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.ARRAY);
                } else if (member.isCollection()) {
                    if (Map.class.equals((Object)member.getCollectionClass())) {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.MAP);
                    } else {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.COLLECTION);
                    }
                } else {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.OBJECT);
                }
                processedClasses.remove(elementClass);
            } else if (log.isTraceEnabled()) {
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                log.trace("depth reached, ignoring {}", (Object)localPrefix);
            }
            --this.level;
            this.maxLevel = oldMaxLevel;
        }
        if ((containedAnn = (ContainedIn)member.getAnnotation(ContainedIn.class)) != null) {
            DocumentBuilder.setAccessible((XMember)member);
            propertiesMetadata.containedInGetters.add((XMember)member);
        }
    }

    private void bindClassAnnotation(String prefix, PropertiesMetadata propertiesMetadata, ClassBridge ann, InitContext context) {
        String fieldName = prefix + ann.name();
        propertiesMetadata.classNames.add(fieldName);
        propertiesMetadata.classStores.add(this.getStore(ann.store()));
        propertiesMetadata.classIndexes.add(this.getIndex(ann.index()));
        propertiesMetadata.classTermVectors.add(this.getTermVector(ann.termVector()));
        propertiesMetadata.classBridges.add(BridgeFactory.extractType(ann));
        propertiesMetadata.classBoosts.add(Float.valueOf(ann.boost().value()));
        Analyzer analyzer = this.getAnalyzer(ann.analyzer(), context);
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
        this.analyzer.addScopedAnalyzer(fieldName, analyzer);
    }

    private void bindFieldAnnotation(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, org.hibernate.search.annotations.Field fieldAnn, InitContext context) {
        DocumentBuilder.setAccessible((XMember)member);
        propertiesMetadata.fieldGetters.add((XMember)member);
        String fieldName = prefix + BinderHelper.getAttributeName((XMember)member, fieldAnn.name());
        propertiesMetadata.fieldNames.add(fieldName);
        propertiesMetadata.fieldStore.add(this.getStore(fieldAnn.store()));
        propertiesMetadata.fieldIndex.add(this.getIndex(fieldAnn.index()));
        propertiesMetadata.fieldTermVectors.add(this.getTermVector(fieldAnn.termVector()));
        propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(fieldAnn, (XMember)member, this.reflectionManager));
        Analyzer analyzer = this.getAnalyzer(fieldAnn.analyzer(), context);
        if (analyzer == null) {
            analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
        }
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analizer should not be undefined");
        }
        this.analyzer.addScopedAnalyzer(fieldName, analyzer);
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded embeddedAnn, XProperty member) {
        String localPrefix = prefix;
        localPrefix = ".".equals(embeddedAnn.prefix()) ? localPrefix + member.getName() + '.' : localPrefix + embeddedAnn.prefix();
        return localPrefix;
    }

    private Field.Store getStore(Store store) {
        switch (store) {
            case NO: {
                return Field.Store.NO;
            }
            case YES: {
                return Field.Store.YES;
            }
            case COMPRESS: {
                return Field.Store.COMPRESS;
            }
        }
        throw new AssertionFailure("Unexpected Store: " + (Object)((Object)store));
    }

    private Field.TermVector getTermVector(TermVector vector) {
        switch (vector) {
            case NO: {
                return Field.TermVector.NO;
            }
            case YES: {
                return Field.TermVector.YES;
            }
            case WITH_OFFSETS: {
                return Field.TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return Field.TermVector.WITH_POSITIONS;
            }
            case WITH_POSITION_OFFSETS: {
                return Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
        }
        throw new AssertionFailure("Unexpected TermVector: " + (Object)((Object)vector));
    }

    private Field.Index getIndex(Index index) {
        switch (index) {
            case NO: {
                return Field.Index.NO;
            }
            case NO_NORMS: {
                return Field.Index.NO_NORMS;
            }
            case TOKENIZED: {
                return Field.Index.TOKENIZED;
            }
            case UN_TOKENIZED: {
                return Field.Index.UN_TOKENIZED;
            }
        }
        throw new AssertionFailure("Unexpected Index: " + (Object)((Object)index));
    }

    private Float getBoost(XAnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Boost boost = (Boost)element.getAnnotation(Boost.class);
        return boost != null ? Float.valueOf(boost.value()) : null;
    }

    private Object getMemberValue(Object bean, XMember getter) {
        Object value;
        try {
            value = getter.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
        return value;
    }

    public void addWorkToQueue(Class entityClass, T entity, Serializable id, WorkType workType, List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor) {
        Document doc;
        for (LuceneWork luceneWork : queue) {
            Serializable currentId;
            if (luceneWork.getEntityClass() != entityClass || (currentId = luceneWork.getId()) == null || !currentId.equals(id)) continue;
            return;
        }
        boolean searchForContainers = false;
        String idInString = this.idBridge.objectToString(id);
        if (workType == WorkType.ADD) {
            doc = this.getDocument(entity, id);
            queue.add(new AddLuceneWork(id, idInString, entityClass, doc));
            searchForContainers = true;
        } else if (workType == WorkType.DELETE || workType == WorkType.PURGE) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
        } else if (workType == WorkType.PURGE_ALL) {
            queue.add(new PurgeAllLuceneWork(entityClass));
        } else if (workType == WorkType.UPDATE || workType == WorkType.COLLECTION) {
            doc = this.getDocument(entity, id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            queue.add(new AddLuceneWork(id, idInString, entityClass, doc));
            searchForContainers = true;
        } else if (workType == WorkType.INDEX) {
            doc = this.getDocument(entity, id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            AddLuceneWork work = new AddLuceneWork(id, idInString, entityClass, doc);
            work.setBatch(true);
            queue.add(work);
            searchForContainers = true;
        } else {
            throw new AssertionFailure("Unknown WorkType: " + (Object)((Object)workType));
        }
        if (searchForContainers) {
            this.processContainedIn(entity, queue, this.rootPropertiesMetadata, searchFactoryImplementor);
        }
    }

    private void processContainedIn(Object instance, List<LuceneWork> queue, PropertiesMetadata metadata, SearchFactoryImplementor searchFactoryImplementor) {
        for (int i = 0; i < metadata.containedInGetters.size(); ++i) {
            XMember member = metadata.containedInGetters.get(i);
            Object value = this.getMemberValue(instance, member);
            if (value == null) continue;
            if (member.isArray()) {
                for (Object arrayValue : (Object[])value) {
                    Class valueClass = Hibernate.getClass((Object)arrayValue);
                    DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(valueClass);
                    if (builder == null) continue;
                    this.processContainedInValue(arrayValue, queue, valueClass, builder, searchFactoryImplementor);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? ((Map)value).values() : (Collection)value;
                for (Object collectionValue : collection) {
                    Class valueClass = Hibernate.getClass(collectionValue);
                    DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(valueClass);
                    if (builder == null) continue;
                    this.processContainedInValue(collectionValue, queue, valueClass, builder, searchFactoryImplementor);
                }
                continue;
            }
            Class valueClass = Hibernate.getClass((Object)value);
            DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(valueClass);
            if (builder == null) continue;
            this.processContainedInValue(value, queue, valueClass, builder, searchFactoryImplementor);
        }
    }

    private void processContainedInValue(Object value, List<LuceneWork> queue, Class valueClass, DocumentBuilder builder, SearchFactoryImplementor searchFactoryImplementor) {
        Serializable id = (Serializable)builder.getMemberValue(value, builder.idGetter);
        builder.addWorkToQueue(valueClass, value, id, WorkType.UPDATE, queue, searchFactoryImplementor);
    }

    public Document getDocument(T instance, Serializable id) {
        Document doc = new Document();
        XClass instanceClass = this.reflectionManager.toXClass(Hibernate.getClass(instance));
        if (this.rootPropertiesMetadata.boost != null) {
            doc.setBoost(this.rootPropertiesMetadata.boost.floatValue());
        }
        Field classField = new Field(CLASS_FIELDNAME, instanceClass.getName(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO);
        doc.add((Fieldable)classField);
        LuceneOptions luceneOptions = new LuceneOptions(Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO, this.idBoost);
        this.idBridge.set(this.idKeywordName, id, doc, luceneOptions);
        this.buildDocumentFields(instance, doc, this.rootPropertiesMetadata);
        return doc;
    }

    private void buildDocumentFields(Object instance, Document doc, PropertiesMetadata propertiesMetadata) {
        Object value;
        XMember member;
        int i;
        if (instance == null) {
            return;
        }
        Object unproxiedInstance = this.unproxy(instance);
        for (i = 0; i < propertiesMetadata.classBridges.size(); ++i) {
            FieldBridge fb = propertiesMetadata.classBridges.get(i);
            fb.set(propertiesMetadata.classNames.get(i), unproxiedInstance, doc, propertiesMetadata.getClassLuceneOptions(i));
        }
        for (i = 0; i < propertiesMetadata.fieldNames.size(); ++i) {
            member = propertiesMetadata.fieldGetters.get(i);
            value = this.getMemberValue(unproxiedInstance, member);
            propertiesMetadata.fieldBridges.get(i).set(propertiesMetadata.fieldNames.get(i), value, doc, propertiesMetadata.getFieldLuceneOptions(i, this.getBoost((XAnnotatedElement)member)));
        }
        block8: for (i = 0; i < propertiesMetadata.embeddedGetters.size(); ++i) {
            member = propertiesMetadata.embeddedGetters.get(i);
            value = this.getMemberValue(unproxiedInstance, member);
            if (value == null) continue;
            PropertiesMetadata embeddedMetadata = propertiesMetadata.embeddedPropertiesMetadata.get(i);
            switch (propertiesMetadata.embeddedContainers.get(i)) {
                case ARRAY: {
                    for (Object arrayValue : (Object[])value) {
                        this.buildDocumentFields(arrayValue, doc, embeddedMetadata);
                    }
                    continue block8;
                }
                case COLLECTION: {
                    for (Object collectionValue : (Collection)value) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata);
                    }
                    continue block8;
                }
                case MAP: {
                    for (Object collectionValue : ((Map)value).values()) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata);
                    }
                    continue block8;
                }
                case OBJECT: {
                    this.buildDocumentFields(value, doc, embeddedMetadata);
                    continue block8;
                }
                default: {
                    throw new AssertionFailure("Unknown embedded container: " + (Object)((Object)propertiesMetadata.embeddedContainers.get(i)));
                }
            }
        }
    }

    private Object unproxy(Object value) {
        if (value instanceof HibernateProxy) {
            value = ((HibernateProxy)value).getHibernateLazyInitializer().getImplementation();
        }
        return value;
    }

    public Term getTerm(Serializable id) {
        if (this.idProvided) {
            return new Term(this.idKeywordName, (String)((Object)id));
        }
        return new Term(this.idKeywordName, this.idBridge.objectToString(id));
    }

    public DirectoryProvider[] getDirectoryProviders() {
        return this.directoryProviders;
    }

    public IndexShardingStrategy getDirectoryProviderSelectionStrategy() {
        return this.shardingStrategy;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private static void setAccessible(XMember member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            member.setAccessible(true);
        }
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    public static Class getDocumentClass(Document document) {
        String className = document.get(CLASS_FIELDNAME);
        try {
            return ReflectHelper.classForName((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    public static Serializable getDocumentId(SearchFactoryImplementor searchFactoryImplementor, Class clazz, Document document) {
        DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(clazz);
        if (builder == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        return (Serializable)builder.getIdBridge().get(builder.getIdKeywordName(), document);
    }

    public static Object[] getDocumentFields(SearchFactoryImplementor searchFactoryImplementor, Class clazz, Document document, String[] fields) {
        DocumentBuilder<Object> builder = searchFactoryImplementor.getDocumentBuilders().get(clazz);
        if (builder == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        int fieldNbr = fields.length;
        Object[] result = new Object[fieldNbr];
        if (builder.idKeywordName != null) {
            DocumentBuilder.populateResult(builder.idKeywordName, builder.idBridge, Field.Store.YES, fields, result, document);
        }
        PropertiesMetadata metadata = builder.rootPropertiesMetadata;
        DocumentBuilder.processFieldsForProjection(metadata, fields, result, document);
        return result;
    }

    private static void processFieldsForProjection(PropertiesMetadata metadata, String[] fields, Object[] result, Document document) {
        int nbrFoEntityFields = metadata.fieldNames.size();
        for (int index = 0; index < nbrFoEntityFields; ++index) {
            DocumentBuilder.populateResult(metadata.fieldNames.get(index), metadata.fieldBridges.get(index), metadata.fieldStore.get(index), fields, result, document);
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index = 0; index < nbrOfEmbeddedObjects; ++index) {
            if (metadata.embeddedContainers.get(index) != PropertiesMetadata.Container.OBJECT) continue;
            DocumentBuilder.processFieldsForProjection(metadata.embeddedPropertiesMetadata.get(index), fields, result, document);
        }
    }

    private static void populateResult(String fieldName, FieldBridge fieldBridge, Field.Store store, String[] fields, Object[] result, Document document) {
        int matchingPosition = DocumentBuilder.getFieldPosition(fields, fieldName);
        if (matchingPosition != -1) {
            if (store != Field.Store.NO && TwoWayFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
                result[matchingPosition] = ((TwoWayFieldBridge)fieldBridge).get(fieldName, document);
                if (log.isTraceEnabled()) {
                    log.trace("Field {} projected as {}", (Object)fieldName, result[matchingPosition]);
                }
            } else {
                if (store == Field.Store.NO) {
                    throw new SearchException("Projecting an unstored field: " + fieldName);
                }
                throw new SearchException("FieldBridge is not a TwoWayFieldBridge: " + fieldBridge.getClass());
            }
        }
    }

    private static int getFieldPosition(String[] fields, String fieldName) {
        int fieldNbr = fields.length;
        for (int index = 0; index < fieldNbr; ++index) {
            if (!fieldName.equals(fields[index])) continue;
            return index;
        }
        return -1;
    }

    public void postInitialize(Set<Class> indexedClasses) {
        Class plainClass = this.reflectionManager.toClass(this.beanClass);
        HashSet<Class> tempMappedSubclasses = new HashSet<Class>();
        for (Class currentClass : indexedClasses) {
            if (!plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
        this.isRoot = true;
        for (Class superClass = plainClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!indexedClasses.contains(superClass)) continue;
            this.isRoot = false;
            break;
        }
    }

    public Set<Class> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    public boolean isSafeFromTupleId() {
        return this.safeFromTupleId;
    }

    private static class PropertiesMetadata {
        public Float boost;
        public Analyzer analyzer;
        public final List<String> fieldNames = new ArrayList<String>();
        public final List<XMember> fieldGetters = new ArrayList<XMember>();
        public final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
        public final List<Field.Store> fieldStore = new ArrayList<Field.Store>();
        public final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
        public final List<Field.TermVector> fieldTermVectors = new ArrayList<Field.TermVector>();
        public final List<XMember> embeddedGetters = new ArrayList<XMember>();
        public final List<PropertiesMetadata> embeddedPropertiesMetadata = new ArrayList<PropertiesMetadata>();
        public final List<Container> embeddedContainers = new ArrayList<Container>();
        public final List<XMember> containedInGetters = new ArrayList<XMember>();
        public final List<String> classNames = new ArrayList<String>();
        public final List<Field.Store> classStores = new ArrayList<Field.Store>();
        public final List<Field.Index> classIndexes = new ArrayList<Field.Index>();
        public final List<FieldBridge> classBridges = new ArrayList<FieldBridge>();
        public final List<Field.TermVector> classTermVectors = new ArrayList<Field.TermVector>();
        public final List<Float> classBoosts = new ArrayList<Float>();

        private PropertiesMetadata() {
        }

        private LuceneOptions getClassLuceneOptions(int i) {
            LuceneOptions options = new LuceneOptions(this.classStores.get(i), this.classIndexes.get(i), this.classTermVectors.get(i), this.classBoosts.get(i));
            return options;
        }

        private LuceneOptions getFieldLuceneOptions(int i, Float boost) {
            LuceneOptions options = new LuceneOptions(this.fieldStore.get(i), this.fieldIndex.get(i), this.fieldTermVectors.get(i), boost);
            return options;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Container {
            OBJECT,
            COLLECTION,
            MAP,
            ARRAY;

        }
    }
}

