/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.search.CacheQuery;
import org.jboss.cache.search.CacheQueryImpl;
import org.jboss.cache.search.SearchableCache;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchableCacheImpl<K, V>
implements SearchableCache<K, V> {
    private Cache<K, V> cache;
    private SearchFactoryImplementor searchFactory;

    public SearchableCacheImpl(Cache<K, V> cache, SearchFactoryImplementor searchFactory) {
        if (cache == null) {
            throw new NullPointerException("Cache is null");
        }
        if (searchFactory == null) {
            throw new NullPointerException("searchFactory is null");
        }
        this.cache = cache;
        this.searchFactory = searchFactory;
    }

    @Override
    public CacheQuery createQuery(Query luceneQuery) {
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache);
    }

    @Override
    public CacheQuery createQuery(Query luceneQuery, Class ... classes) {
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, classes);
    }

    public Configuration getConfiguration() {
        return this.cache.getConfiguration();
    }

    public Node getRoot() {
        return this.cache.getRoot();
    }

    public void addCacheListener(Object listener) {
        this.cache.addCacheListener(listener);
    }

    public void removeCacheListener(Object listener) {
        this.cache.removeCacheListener(listener);
    }

    public Set getCacheListeners() {
        return this.cache.getCacheListeners();
    }

    public V put(String fqn, K key, V value) {
        return (V)this.cache.put(fqn, key, value);
    }

    public void put(String fqn, Map<K, V> data) {
        this.cache.put(fqn, data);
    }

    public V remove(String fqn, K key) {
        return (V)this.cache.remove(fqn, key);
    }

    public boolean removeNode(String fqn) {
        return this.cache.removeNode(fqn);
    }

    public Node getNode(String fqn) {
        return this.cache.getNode(fqn);
    }

    public V get(String fqn, K key) {
        return (V)this.cache.get(fqn, key);
    }

    public void create() throws CacheException {
        this.cache.create();
    }

    public void start() throws CacheException {
        this.cache.start();
    }

    public void stop() {
        this.cache.stop();
    }

    public void destroy() {
        this.cache.destroy();
    }

    public CacheStatus getCacheStatus() {
        return this.cache.getCacheStatus();
    }

    public InvocationContext getInvocationContext() {
        return this.cache.getInvocationContext();
    }

    public void setInvocationContext(InvocationContext ctx) {
        this.cache.setInvocationContext(ctx);
    }

    public Address getLocalAddress() {
        return this.cache.getLocalAddress();
    }

    public List getMembers() {
        return this.cache.getMembers();
    }

    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.cache.move(nodeToMove, newParent);
    }

    public String getVersion() {
        return this.cache.getVersion();
    }

    public Set<K> getKeys(String fqn) {
        return this.cache.getKeys(fqn);
    }

    public void clearData(String fqn) {
        this.cache.clearData(fqn);
    }

    public void clearData(Fqn<?> fqn) {
        this.cache.clearData(fqn);
    }

    public Set getKeys(Fqn<?> fqn) {
        return this.cache.getKeys(fqn);
    }

    public Map getData(Fqn<?> fqn) {
        return this.cache.getData(fqn);
    }

    public void move(Fqn<?> nodeToMove, Fqn<?> newParent) throws NodeNotExistsException {
        this.cache.move(nodeToMove, newParent);
    }

    public boolean removeRegion(Fqn<?> fqn) {
        return this.cache.removeRegion(fqn);
    }

    public Region getRegion(Fqn<?> fqn, boolean createIfAbsent) {
        return this.cache.getRegion(fqn, createIfAbsent);
    }

    public void evict(Fqn<?> fqn) {
        this.cache.evict(fqn);
    }

    public void evict(Fqn<?> fqn, boolean recursive) {
        this.cache.evict(fqn, recursive);
    }

    public V get(Fqn<?> fqn, K key) {
        return (V)this.cache.get(fqn, key);
    }

    public Node getNode(Fqn<?> fqn) {
        return this.cache.getNode(fqn);
    }

    public boolean removeNode(Fqn<?> fqn) {
        return this.cache.removeNode(fqn);
    }

    public V remove(Fqn<?> fqn, K key) {
        return (V)this.cache.remove(fqn, key);
    }

    public void put(Fqn<?> fqn, Map<K, V> data) {
        this.cache.put(fqn, data);
    }

    public void putForExternalRead(Fqn<?> fqn, K key, V value) {
        this.cache.putForExternalRead(fqn, key, value);
    }

    public V put(Fqn<?> fqn, K key, V value) {
        return (V)this.cache.put(fqn, key, value);
    }
}

