/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode<K, V> {
    protected Map<Object, Node<K, V>> children;
    protected Fqn<?> fqn;
    protected short flags = 0;

    protected final boolean isFlagSet(NodeFlags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(NodeFlags flag, boolean value) {
        if (value) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    protected final void setFlag(NodeFlags flag) {
        this.flags = (short)(this.flags | flag.mask);
    }

    protected final void unsetFlag(NodeFlags flag) {
        this.flags = (short)(this.flags & ~flag.mask);
    }

    public boolean isDeleted() {
        return this.isFlagSet(NodeFlags.DELETED);
    }

    public void markAsDeleted(boolean marker) {
        this.markAsDeleted(marker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDeleted(boolean marker, boolean recursive) {
        this.setFlag(NodeFlags.DELETED, marker);
        if (recursive && this.children != null) {
            AbstractNode abstractNode = this;
            synchronized (abstractNode) {
                for (Node<K, V> child : this.children.values()) {
                    ((NodeSPI)child).markAsDeleted(marker, true);
                }
            }
        }
    }

    public void setResident(boolean resident) {
        this.setFlag(NodeFlags.RESIDENT, resident);
    }

    public boolean isResident() {
        return this.isFlagSet(NodeFlags.RESIDENT);
    }

    public boolean equals(Object another) {
        if (another instanceof AbstractNode) {
            AbstractNode anotherNode = (AbstractNode)another;
            return this.fqn == null && anotherNode.fqn == null || this.fqn != null && anotherNode.fqn != null && this.fqn.equals(anotherNode.fqn);
        }
        return false;
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeFlags {
        CHILDREN_LOADED(1),
        DATA_LOADED(2),
        LOCK_FOR_CHILD_INSERT_REMOVE(4),
        VALID(8),
        DELETED(16),
        RESIDENT(32),
        MODIFIED_IN_WORKSPACE(64),
        CREATED_IN_WORKSPACE(128),
        CHILDREN_MODIFIED_IN_WORKSPACE(256),
        VERSIONING_IMPLICIT(512),
        RESURRECTED_IN_WORKSPACE(1024);

        protected final short mask;

        private NodeFlags(int mask) {
            this.mask = (short)mask;
        }
    }
}

