/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.lang.reflect.Method;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.RPCManager;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.EmptyConstructorFactory;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={RPCManager.class, NodeFactory.class})
public class RuntimeConfigAwareFactory
extends EmptyConstructorFactory {
    @Override
    protected <T> T construct(Class<T> componentType) {
        T component = super.construct(componentType);
        Method setter = BeanUtils.setterMethod(RuntimeConfig.class, componentType);
        if (setter != null) {
            try {
                setter.invoke((Object)this.configuration.getRuntimeConfig(), component);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to put newly constructed component of type " + componentType + " in the RuntimeConfig", e);
            }
        }
        return component;
    }
}

