/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StripedLock {
    private static final int DEFAULT_CONCURRENCY = 20;
    private final int lockSegmentMask;
    private final int lockSegmentShift;
    final ReentrantReadWriteLock[] sharedLocks;
    private final Log log = LogFactory.getLog(StripedLock.class);

    public StripedLock() {
        this(20);
    }

    public StripedLock(int concurrency) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrency; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        this.sharedLocks = new ReentrantReadWriteLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantReadWriteLock();
        }
    }

    public void acquireLock(Fqn fqn, boolean exclusive) {
        ReentrantReadWriteLock lock = this.getLock(fqn);
        if (exclusive) {
            lock.writeLock().lock();
        } else {
            lock.readLock().lock();
        }
    }

    public void releaseLock(Fqn fqn) {
        ReentrantReadWriteLock lock = this.getLock(fqn);
        if (lock.isWriteLockedByCurrentThread()) {
            lock.writeLock().unlock();
            if (lock.isWriteLockedByCurrentThread() && this.log.isWarnEnabled()) {
                this.log.warn((Object)("Write lock still exists on Fqn " + fqn + " for current thread.  Perhaps this was write-locked more than once?"));
            }
        } else {
            try {
                lock.readLock().unlock();
            }
            catch (IllegalMonitorStateException imse) {
                throw new CacheException("Lock is held by a different thread!  Cannot be unlocked by current thread.", imse);
            }
        }
    }

    ReentrantReadWriteLock getLock(Object o) {
        return this.sharedLocks[this.hashToIndex(o)];
    }

    int hashToIndex(Object o) {
        return this.hash(o) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    int hash(Object x) {
        int h = x.toString().hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public void releaseAllLocks(List<Fqn> fqns) {
        for (Fqn f : fqns) {
            this.releaseLock(f);
        }
    }

    public void acquireAllLocks(List<Fqn> fqns, boolean exclusive) {
        for (Fqn f : fqns) {
            this.acquireLock(f, exclusive);
        }
    }
}

