/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ImmutableSetCopy<E>
extends AbstractSet<E>
implements Externalizable {
    private static final long serialVersionUID = 11929568968766L;
    private E[] elements;
    private int size;

    public ImmutableSetCopy(Collection<E> set) {
        this.size = set.size();
        Object[] tempElements = new Object[this.size];
        this.elements = set.toArray(tempElements);
    }

    public ImmutableSetCopy(E[] array) {
        this.elements = array;
        this.size = this.elements.length;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < ImmutableSetCopy.this.size;
            }

            @Override
            public E next() {
                if (this.cursor >= ImmutableSetCopy.this.size) {
                    throw new NoSuchElementException();
                }
                return ImmutableSetCopy.this.elements[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        for (E e : this.elements) {
            out.writeObject(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.elements = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = in.readObject();
        }
    }
}

