//package org.jboss.cache.search.blackbox;
//
//import org.apache.lucene.analysis.standard.StandardAnalyzer;
//import org.apache.lucene.queryParser.ParseException;
//import org.apache.lucene.queryParser.QueryParser;
//import org.apache.lucene.search.Query;
//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
//import org.jboss.cache.Cache;
//import org.jboss.cache.DefaultCacheFactory;
//import org.jboss.cache.Fqn;
//import org.jboss.cache.config.Configuration;
//import org.jboss.cache.pojo.PojoCache;
//import org.jboss.cache.pojo.PojoCacheFactory;
//import org.jboss.cache.search.CacheQuery;
//import org.jboss.cache.search.SearchableCache;
//import org.jboss.cache.search.SearchableCacheFactory;
//import org.jboss.cache.search.helper.IndexCleanUp;
//import org.jboss.cache.search.test.Person;
//import org.testng.annotations.AfterMethod;
//import org.testng.annotations.BeforeMethod;
//import org.testng.annotations.Test;
//
//import java.util.List;
//
///**
// * Same as LocalCacheTest except that you will use a POJO Cache instead and use pojoCache.attach() ad pojoCache.detach()
// * instead of cache.put() and cache.remove().
// * <p/>
// *
// * @author Navin Surtani (<a href="mailto:nsurtani@redhat.com">nsurtani@redhat.com</a>)
// */
//
//@Test(groups = "functional", enabled = false)
//public class LocalPOJOCacheTest
//{
//   SearchableCache searchableCache;
//   PojoCache pojo;
//   Person person1;
//   Person person2;
//   Person person3;
//   Person person4;
//   QueryParser queryParser;
//   Query luceneQuery;
//   CacheQuery cacheQuery;
//   List found;
//   private static final Log log = LogFactory.getLog(LocalPOJOCacheTest.class);
//
//
//   @BeforeMethod
//   public void setUp()
//   {
//      boolean toStart = false;
//      pojo = PojoCacheFactory.createCache(new Configuration(), toStart);
//      pojo.start(); // if toStart above is true, it will starts the cache automatically.
//      searchableCache = new SearchableCacheFactory().createSearchableCache(pojo.getCache(), Person.class);
//
//      person1 = new Person();
//      person1.setName("Navin Surtani");
//      person1.setBlurb("Likes playing WoW");
//
//      person2 = new Person();
//      person2.setName("BigGoat");
//      person2.setBlurb("Eats grass");
//
//      person3 = new Person();
//      person3.setName("MiniGoat");
//      person3.setBlurb("Eats cheese");
//
//      pojo.attach(Fqn.fromString("/a/b/c"), person1);
//      pojo.attach(Fqn.fromString("/a/b/d"), person2);
//      pojo.attach(Fqn.fromString("/a/b/c"), person3);
//
//
//   }
//
//   @AfterMethod
//   public void tearDown()
//   {
//      if (pojo != null) pojo.stop();
//      if (searchableCache != null) searchableCache.stop();
//      IndexCleanUp.cleanUpIndexes();
//   }
//
//   public void testSimple() throws ParseException
//   {
//      queryParser = new QueryParser("blurb", new StandardAnalyzer());
//      luceneQuery = queryParser.parse("playing");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//
//      found = cacheQuery.list();
//
//   }
//
//   public void testMultipleResults() throws ParseException
//   {
//      queryParser = new QueryParser("blurb", new StandardAnalyzer());
//      luceneQuery = queryParser.parse("Eats");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//      found = cacheQuery.list();
//
//      assert found.size() == 2;
//      assert !found.get(1).equals(person2);
//      assert !found.get(0).equals(person3);
//
//   }
//
//   public void testModified() throws ParseException
//   {
//      queryParser = new QueryParser("blurb", new StandardAnalyzer());
//      luceneQuery = queryParser.parse("playing");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//
//      found = cacheQuery.list();
//
//      assert found.size() == 1;
////      assert found.get(0).equals(person1);
//
//      person1.setBlurb("Likes pizza");
//
//      pojo.attach(Fqn.fromString("/a/b/c/"), person1);
//
//      queryParser = new QueryParser("blurb", new StandardAnalyzer());
//      luceneQuery = queryParser.parse("pizza");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//
//      found = cacheQuery.list();
//
//      assert found.size() == 1;
////      assert found.get(0).equals(person1);
//   }
//
//   public void testAdded() throws ParseException
//   {
//      queryParser = new QueryParser("blurb", new StandardAnalyzer());
//      luceneQuery = queryParser.parse("eats");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//      found = cacheQuery.list();
//
//      assert found.size() == 2 : "Size of list should be 2";
//      assert found.contains(person2);
//      assert found.contains(person3);
//      assert !found.contains(person4) : "This should not contain object person4";
//
//      person4 = new Person();
//      person4.setName("MightyGoat");
//      person4.setBlurb("Also eats grass");
//
//      pojo.attach(Fqn.fromString("/r/a/m/"), person4);
//
//      luceneQuery = queryParser.parse("eats");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//      found = cacheQuery.list();
//
//      assert found.size() == 3 : "Size of list should be 3";
//      assert found.contains(person2);
//      assert found.contains(person3);
//      assert found.contains(person4) : "This should now contain object person4";
//   }
//
//   public void testRemoved() throws ParseException
//   {
//      queryParser = new QueryParser("blurb", new StandardAnalyzer());
//      luceneQuery = queryParser.parse("eats");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//      found = cacheQuery.list();
//
//      assert found.size() == 2;
//      assert found.contains(person2);
//      assert found.contains(person3) : "This should still contain object person3";
//
//      pojo.detach("/a/b/d");
//
//      luceneQuery = queryParser.parse("eats");
//      cacheQuery = searchableCache.createQuery(luceneQuery);
//      found = cacheQuery.list();
//
//      assert found.size() == 1;
//      assert found.contains(person2);
//      assert !found.contains(person3) : "The search should not return person3";
//
//
//   }
//
//}
//
//
//
