///*
// * JBoss, Home of Professional Open Source
// * Copyright ${year}, Red Hat Middleware LLC, and individual contributors
// * by the @authors tag. See the copyright.txt in the distribution for a
// * full listing of individual contributors.
// *
// * This is free software; you can redistribute it and/or modify it
// * under the terms of the GNU Lesser General Public License as
// * published by the Free Software Foundation; either version 2.1 of
// * the License, or (at your option) any later version.
// *
// * This software is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// * Lesser General Public License for more details.
// *
// * You should have received a copy of the GNU Lesser General Public
// * License along with this software; if not, write to the Free
// * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
// */
//
//package org.jboss.cache.search;
//
//import org.hibernate.search.impl.SearchFactoryImpl;
//import org.hibernate.search.backend.TransactionContext;
//import org.hibernate.search.backend.Work;
//import org.hibernate.search.backend.WorkType;
//import org.hibernate.search.engine.SearchFactoryImplementor;
//import org.jboss.cache.notifications.event.NodeModifiedEvent;
//import org.jboss.cache.pojo.notification.annotation.*;
//import org.jboss.cache.pojo.notification.event.AttachedEvent;
//import org.jboss.cache.pojo.notification.event.DetachedEvent;
//import org.jboss.cache.pojo.notification.event.Event;
//import org.jboss.cache.pojo.PojoCache;
//import org.jboss.cache.Fqn;
//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
//
//import javax.transaction.Transaction;
//
///**
// * @author Navin Surtani (<a href="mailto:nsurtani@redhat.com">nsurtani@redhat.com</a>)
// */
//
//@PojoCacheListener
//public class SearchablePojoListener
//{
//   private SearchFactoryImplementor searchFactory;
//   private static final Log log = LogFactory.getLog(SearchablePojoListener.class);
//   private String pojoKey = "pojoKey";
//
//   public SearchablePojoListener(SearchFactoryImplementor searchFactory)
//   {
//      this.searchFactory = searchFactory;
//   }
//
//   /**
//    * Takes in a NodeModifiedEvent and updates the Lucene indexes using methods on the NodeModifiedEvent class.
//    *
//    * @param event that has occured - or a node that has been changed. {@link org.jboss.cache.notifications.event.NodeModifiedEvent}
//    * @throws InvalidKeyException if an invalid key is given.
//    */
//
//   @Attached
//   public void handleAttach(AttachedEvent event) throws InvalidKeyException
//   {
//      System.out.println("Pojocache.attach() called");
//      Object added = event.getSource();
//      Fqn fqn = event.getContext().getPojoCache().getInternalFqn(added);
//
//      CacheEntityId cacheEntityId = new CacheEntityId(fqn, pojoKey);
//
//      TransactionContext ctx = new PojoTransactionContext(event);
//
//      searchFactory.getWorker().performWork(new Work(added, cacheEntityId.getDocumentId(), WorkType.ADD), ctx);
//   }
//
//
//   @Detached
//   public void handleDetach (DetachedEvent event) throws InvalidKeyException
//   {
//      Object deleted = event.getSource();
//      Fqn fqn = event.getContext().getPojoCache().getInternalFqn(deleted);
//
//      CacheEntityId cacheEntityId = new CacheEntityId(fqn, pojoKey);
//
//      TransactionContext ctx = new PojoTransactionContext(event);
//
//      searchFactory.getWorker().performWork(new Work(deleted, cacheEntityId.getDocumentId(), WorkType.DELETE), ctx);
//   }
//
//
//   //TODO: Sort out updating Lucene for the following annotations: -
////   @FieldModified
////   @ListModified
////   @ArrayModified
////   @SetModified
//
//}
