/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jpa.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.hql.QueryExecutionRequestException;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.SearchException;
import org.hibernate.transform.ResultTransformer;

public class FullTextQueryImpl
implements org.hibernate.search.jpa.FullTextQuery {
    private final FullTextQuery query;
    private final Session session;

    public FullTextQueryImpl(FullTextQuery query, Session session) {
        this.query = query;
        this.session = session;
    }

    public org.hibernate.search.jpa.FullTextQuery setSort(Sort sort) {
        this.query.setSort(sort);
        return this;
    }

    public org.hibernate.search.jpa.FullTextQuery setFilter(Filter filter) {
        this.query.setFilter(filter);
        return this;
    }

    public int getResultSize() {
        return this.query.getResultSize();
    }

    public org.hibernate.search.jpa.FullTextQuery setCriteriaQuery(Criteria criteria) {
        this.query.setCriteriaQuery(criteria);
        return this;
    }

    public org.hibernate.search.jpa.FullTextQuery setProjection(String ... fields) {
        this.query.setProjection(fields);
        return this;
    }

    public FullTextFilter enableFullTextFilter(String name) {
        return this.query.enableFullTextFilter(name);
    }

    public void disableFullTextFilter(String name) {
        this.query.disableFullTextFilter(name);
    }

    public org.hibernate.search.jpa.FullTextQuery setResultTransformer(ResultTransformer transformer) {
        this.query.setResultTransformer(transformer);
        return this;
    }

    public List getResultList() {
        try {
            return this.query.list();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SearchException he) {
            this.throwPersistenceException(he);
            throw he;
        }
    }

    private void throwPersistenceException(Exception e) {
        if (e instanceof StaleStateException) {
            PersistenceException pe = this.wrapStaleStateException((StaleStateException)e);
            this.throwPersistenceException(pe);
        } else if (e instanceof ConstraintViolationException) {
            this.throwPersistenceException((PersistenceException)new EntityExistsException((Throwable)e));
        } else if (e instanceof ObjectNotFoundException) {
            this.throwPersistenceException((PersistenceException)new EntityNotFoundException(e.getMessage()));
        } else if (e instanceof NonUniqueResultException) {
            this.throwPersistenceException((PersistenceException)new javax.persistence.NonUniqueResultException(e.getMessage()));
        } else if (e instanceof UnresolvableObjectException) {
            this.throwPersistenceException((PersistenceException)new EntityNotFoundException(e.getMessage()));
        } else {
            if (e instanceof QueryException) {
                throw new IllegalArgumentException(e);
            }
            if (e instanceof TransientObjectException) {
                throw new IllegalStateException(e);
            }
            this.throwPersistenceException(new PersistenceException((Throwable)e));
        }
    }

    void throwPersistenceException(PersistenceException e) {
        if (e instanceof NoResultException || !(e instanceof javax.persistence.NonUniqueResultException)) {
            // empty if block
        }
        throw e;
    }

    PersistenceException wrapStaleStateException(StaleStateException e) {
        Object entity;
        StaleObjectStateException sose;
        Serializable identifier;
        OptimisticLockException pe = e instanceof StaleObjectStateException ? ((identifier = (sose = (StaleObjectStateException)e).getIdentifier()) != null ? ((entity = this.session.load(sose.getEntityName(), identifier)) instanceof Serializable ? new OptimisticLockException(null, (Throwable)e, entity) : new OptimisticLockException((Throwable)e)) : new OptimisticLockException((Throwable)e)) : new OptimisticLockException((Throwable)e);
        return pe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSingleResult() {
        try {
            List result = this.query.list();
            if (result.size() == 0) {
                this.throwPersistenceException((PersistenceException)new NoResultException("No entity found for query"));
                return null;
            } else {
                if (result.size() <= 1) return result.get(0);
                HashSet uniqueResult = new HashSet(result);
                if (uniqueResult.size() <= 1) return uniqueResult.iterator().next();
                this.throwPersistenceException((PersistenceException)new javax.persistence.NonUniqueResultException("result returns " + uniqueResult.size() + " elements"));
            }
            return null;
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException((Exception)((Object)he));
            return null;
        }
    }

    public Query setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Negative (" + maxResult + ") parameter passed in to setMaxResults");
        }
        this.query.setMaxResults(maxResult);
        return this;
    }

    public Query setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.query.setFirstResult(firstResult);
        return this;
    }

    public Explanation explain(int documentId) {
        return this.query.explain(documentId);
    }

    public int executeUpdate() {
        throw new IllegalStateException("Update not allowed in FullTextQueries");
    }

    public Query setHint(String hintName, Object value) {
        return this;
    }

    public Query setParameter(String name, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(int position, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.query.setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.query.setFlushMode(FlushMode.COMMIT);
        }
        return this;
    }
}

