/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.marshall.NodeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class DataContainerImpl
implements DataContainer {
    private static final Log log = LogFactory.getLog(DataContainerImpl.class);
    private static boolean trace = log.isTraceEnabled();
    private volatile NodeSPI root;
    private volatile InternalNode rootInternal;
    private final Set<Fqn> internalFqns = new HashSet<Fqn>();
    private NodeFactory nodeFactory;
    private LockManager lockManager;
    private BuddyFqnTransformer buddyFqnTransformer;
    private Configuration config;
    private boolean usingMvcc;
    private static final InternalNode[] NULL_ARRAY = new InternalNode[]{null, null};

    @Inject
    public void injectDependencies(NodeFactory nodeFactory, LockManager lockManager, BuddyFqnTransformer transformer, Configuration configuration) {
        this.setDependencies(nodeFactory, lockManager);
        this.createRootNode();
        this.buddyFqnTransformer = transformer;
        this.config = configuration;
    }

    public void setDependencies(NodeFactory nodeFactory, LockManager lockManager) {
        this.nodeFactory = nodeFactory;
        this.lockManager = lockManager;
    }

    @Start(priority=12)
    public void createRootNode() {
        boolean bl = this.usingMvcc = this.config != null && this.config.getNodeLockingScheme() == Configuration.NodeLockingScheme.MVCC;
        if (trace) {
            log.trace((Object)("Starting data container.  Using MVCC? " + this.usingMvcc));
        }
        NodeSPI tempRoot = this.nodeFactory.createRootNode();
        Class<?> currentRootType = this.root == null ? null : this.root.getDelegationTarget().getClass();
        Class<?> tempRootType = tempRoot.getDelegationTarget().getClass();
        if (!tempRootType.equals(currentRootType)) {
            if (trace) {
                log.trace((Object)("Setting root node to an instance of " + tempRootType));
            }
            this.setRoot(tempRoot);
        }
        if (this.usingMvcc && this.rootInternal == null) {
            this.setRoot(this.root);
        }
        if (this.root != null) {
            this.root.setChildrenLoaded(true);
        }
        if (this.rootInternal != null) {
            this.rootInternal.setChildrenLoaded(true);
        }
    }

    @Stop(priority=100)
    public void stop() {
        if (this.root != null) {
            this.root.clearDataDirect();
            this.root.removeChildrenDirect();
        } else if (this.rootInternal != null) {
            this.rootInternal.clear();
            this.rootInternal.removeChildren();
        }
    }

    @Override
    @Deprecated
    public NodeSPI getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Object root) {
        if (root == null) {
            throw new CacheException("Attempting to set a null node as a root node!");
        }
        if (this.usingMvcc && root instanceof InternalNode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting rootInternal to " + root));
            }
            this.rootInternal = (InternalNode)root;
            this.root = null;
        } else {
            this.root = (NodeSPI)root;
            if (this.usingMvcc) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting rootInternal to " + this.root.getDelegationTarget()));
                }
                this.rootInternal = this.root.getDelegationTarget();
                this.root = null;
            }
        }
    }

    @Override
    public boolean isResident(Fqn fqn) {
        if (this.usingMvcc) {
            InternalNode in = this.peekInternalNode(fqn, false);
            return in != null && in.isResident();
        }
        NodeSPI nodeSPI = this.peek(fqn, false, false);
        return nodeSPI != null && nodeSPI.isResident();
    }

    @Override
    public void registerInternalFqn(Fqn fqn) {
        this.internalFqns.add(fqn);
    }

    @Override
    public NodeSPI peek(Fqn fqn) {
        return this.peek(fqn, false, false);
    }

    @Override
    public NodeSPI peek(Fqn fqn, boolean includeDeletedNodes) {
        return this.peek(fqn, includeDeletedNodes, false);
    }

    @Override
    public NodeSPI peek(Fqn fqn, boolean includeDeletedNodes, boolean includeInvalidNodes) {
        if (fqn == null || fqn.size() == 0) {
            return this.getRoot();
        }
        NodeSPI n = this.getRoot();
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChildDirect(obj)) == null) {
                return null;
            }
            if (!includeDeletedNodes && n.isDeleted()) {
                return null;
            }
            if (includeInvalidNodes || n.isValid()) continue;
            return null;
        }
        return n;
    }

    @Override
    public boolean exists(Fqn fqn) {
        return this.usingMvcc ? this.peekInternalNode(fqn, false) != null : this.peek(fqn, false, false) != null;
    }

    @Override
    public boolean hasChildren(Fqn fqn) {
        if (fqn == null) {
            return false;
        }
        if (this.usingMvcc) {
            InternalNode in = this.peekInternalNode(fqn, false);
            return in != null && in.hasChildren();
        }
        NodeSPI n = this.peek(fqn);
        return n != null && n.hasChildrenDirect();
    }

    @Override
    public List<NodeData> buildNodeData(List<NodeData> list, NodeSPI node, boolean mapSafe) {
        if (this.usingMvcc) {
            return this.buildNodeData(list, node.getDelegationTarget(), node.getData(), mapSafe);
        }
        return this.buildNodeDataLegacy(list, node, mapSafe);
    }

    private List<NodeData> buildNodeData(List<NodeData> list, InternalNode<?, ?> node, Map dataInNode, boolean mapSafe) {
        NodeData data = new NodeData(this.buddyFqnTransformer.getActualFqn(node.getFqn()), dataInNode, mapSafe);
        list.add(data);
        for (InternalNode childNode : node.getChildrenMap().values()) {
            this.buildNodeData(list, childNode, childNode.getData(), true);
        }
        return list;
    }

    @Deprecated
    private List<NodeData> buildNodeDataLegacy(List<NodeData> list, NodeSPI node, boolean mapSafe) {
        NodeData data = new NodeData(this.buddyFqnTransformer.getActualFqn(node.getFqn()), node.getDataDirect(), mapSafe);
        list.add(data);
        for (NodeSPI childNode : node.getChildrenDirect()) {
            this.buildNodeData(list, childNode, true);
        }
        return list;
    }

    @Override
    public List<Fqn> getNodesForEviction(Fqn fqn, boolean recursive) {
        ArrayList<Fqn> result = new ArrayList<Fqn>();
        if (this.usingMvcc) {
            InternalNode node = this.peekInternalNode(fqn, false);
            if (recursive) {
                if (node != null) {
                    this.recursiveAddEvictionNodes(node, result);
                }
            } else {
                if (node == null) {
                    result.add(fqn);
                    return result;
                }
                if (fqn.isRoot()) {
                    for (Object childName : node.getChildrenNames()) {
                        if (node.isResident()) continue;
                        result.add(Fqn.fromRelativeElements(fqn, childName));
                    }
                } else if (!node.isResident()) {
                    result.add(fqn);
                }
            }
            return result;
        }
        NodeSPI node = this.peek(fqn, false);
        if (recursive) {
            if (node != null) {
                this.recursiveAddEvictionNodes(node, result);
            }
        } else {
            if (node == null) {
                result.add(fqn);
                return result;
            }
            if (fqn.isRoot()) {
                for (Object childName : node.getChildrenNamesDirect()) {
                    if (node.isResident()) continue;
                    result.add(Fqn.fromRelativeElements(fqn, childName));
                }
            } else if (!node.isResident()) {
                result.add(fqn);
            }
        }
        return result;
    }

    private void recursiveAddEvictionNodes(NodeSPI<?, ?> node, List<Fqn> result) {
        for (NodeSPI<?, ?> child : node.getChildrenDirect()) {
            this.recursiveAddEvictionNodes(child, result);
        }
        Fqn fqn = node.getFqn();
        if (!fqn.isRoot() && !node.isResident()) {
            result.add(fqn);
        }
    }

    private void recursiveAddEvictionNodes(InternalNode<?, ?> node, List<Fqn> result) {
        for (InternalNode<?, ?> child : node.getChildren()) {
            this.recursiveAddEvictionNodes(child, result);
        }
        Fqn fqn = node.getFqn();
        if (!fqn.isRoot() && !node.isResident()) {
            result.add(fqn);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public Set<Fqn> getInternalFqns() {
        return Collections.unmodifiableSet(this.internalFqns);
    }

    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        if (!details) {
            sb.append(this.getClass().getName()).append(" [").append(this.getNumberOfNodes()).append(" nodes, ");
            sb.append(this.getNumberOfLocksHeld()).append(" locks]");
        } else {
            if (this.root == null) {
                return sb.toString();
            }
            for (NodeSPI n : this.root.getChildrenDirect()) {
                n.print(sb, indent);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public int getNumberOfLocksHeld() {
        return this.numLocks(this.root);
    }

    private int numLocks(NodeSPI n) {
        int num = 0;
        if (n != null) {
            if (this.lockManager.isLocked(n)) {
                ++num;
            }
            for (NodeSPI cn : n.getChildrenDirect(true)) {
                num += this.numLocks(cn);
            }
        }
        return num;
    }

    @Override
    @ManagedOperation(description="Returns the number of nodes in the data container")
    public int getNumberOfNodes() {
        if (!this.usingMvcc) {
            return this.numNodes(this.root) - 1;
        }
        return this.numNodesMvcc(this.rootInternal) - 1;
    }

    private int numNodesMvcc(InternalNode node) {
        int count = 1;
        if (node != null) {
            Set children = node.getChildren();
            for (InternalNode child : children) {
                count += this.numNodesMvcc(child);
            }
        }
        return count;
    }

    private int numNodes(NodeSPI n) {
        int count = 1;
        if (n != null) {
            for (NodeSPI child : n.getChildrenDirect()) {
                count += this.numNodes(child);
            }
        }
        return count;
    }

    @Override
    @ManagedOperation(description="Prints details of the data container")
    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        if (this.root == null) {
            this.rootInternal.printDetails(sb, 0);
        } else {
            this.root.printDetails(sb, 0);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String printLockInfo() {
        return this.lockManager.printLockInfo(this.root);
    }

    @Override
    public int getNumberOfAttributes(Fqn fqn) {
        return this.usingMvcc ? this.numAttributes(this.peekInternalNode(fqn, false)) : this.numAttributes(this.peek(fqn));
    }

    private int numAttributes(NodeSPI n) {
        int count = 0;
        for (NodeSPI child : n.getChildrenDirect()) {
            count += this.numAttributes(child);
        }
        return count += n.getDataDirect().size();
    }

    private int numAttributesMvcc(InternalNode n) {
        int count = 0;
        for (InternalNode child : n.getChildren()) {
            count += this.numAttributesMvcc(child);
        }
        return count += n.getData().size();
    }

    private int numAttributes(InternalNode n) {
        int count = 0;
        for (InternalNode child : n.getChildren()) {
            count += this.numAttributes((NodeSPI)((Object)child));
        }
        return count += n.getData().size();
    }

    @Override
    @ManagedOperation(description="Returns the number of attributes in all nodes in the data container")
    public int getNumberOfAttributes() {
        return this.usingMvcc ? this.numAttributesMvcc(this.rootInternal) : this.numAttributes(this.root);
    }

    @Override
    public boolean removeFromDataStructure(Fqn f, boolean skipMarkerCheck) {
        return this.usingMvcc ? this.removeMvcc(f, skipMarkerCheck) : this.removeLegacy(f, skipMarkerCheck);
    }

    private boolean removeMvcc(Fqn f, boolean skipMarkerCheck) {
        InternalNode n = this.peekInternalNode(f, true);
        if (n == null) {
            return false;
        }
        if (trace) {
            log.trace((Object)("Performing a real remove for node " + f + ", marked for removal."));
        }
        if (skipMarkerCheck || n.isRemoved()) {
            if (n.getFqn().isRoot()) {
                n.setRemoved(true);
                n.setValid(false, true);
                n.setValid(true, false);
                n.removeChildren();
                return true;
            }
            n.setValid(false, true);
            InternalNode parent = this.peekInternalNode(f.getParent(), true);
            return parent.removeChild(n.getFqn().getLastElement());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node " + f + " NOT marked for removal as expected, not removing!"));
        }
        return false;
    }

    private boolean removeLegacy(Fqn f, boolean skipMarkerCheck) {
        NodeSPI n = this.peek(f, true);
        if (n == null) {
            return false;
        }
        if (trace) {
            log.trace((Object)("Performing a real remove for node " + f + ", marked for removal."));
        }
        if (skipMarkerCheck || n.isDeleted()) {
            if (n.getFqn().isRoot()) {
                n.markAsDeleted(true);
                n.setValid(false, true);
                n.setValid(true, false);
                n.removeChildrenDirect();
                return true;
            }
            n.setValid(false, true);
            NodeSPI parent = this.peek(f.getParent(), true);
            return parent.removeChildDirect(n.getFqn().getLastElement());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node " + f + " NOT marked for removal as expected, not removing!"));
        }
        return false;
    }

    @Override
    public void evict(Fqn fqn, boolean recursive) {
        List<Fqn> toEvict = this.getNodesForEviction(fqn, recursive);
        for (Fqn aFqn : toEvict) {
            this.evict(aFqn);
        }
    }

    @Override
    public boolean evict(Fqn fqn) {
        if (!this.exists(fqn)) {
            return true;
        }
        if (this.hasChildren(fqn)) {
            if (trace) {
                log.trace((Object)("removing DATA as node has children: evict(" + fqn + ")"));
            }
            if (this.usingMvcc) {
                this.removeData(fqn);
            } else {
                this.removeDataLegacy(fqn);
            }
            return false;
        }
        if (trace) {
            log.trace((Object)("removing NODE as it is a leaf: evict(" + fqn + ")"));
        }
        if (this.usingMvcc) {
            this.removeNode(fqn);
        } else {
            this.removeNodeLegacy(fqn);
        }
        return true;
    }

    private void removeNodeLegacy(Fqn fqn) {
        NodeSPI targetNode = this.peek(fqn, false, true);
        if (targetNode == null) {
            return;
        }
        NodeSPI parentNode = targetNode.getParentDirect();
        targetNode.setValid(false, false);
        if (parentNode != null) {
            parentNode.removeChildDirect(fqn.getLastElement());
            parentNode.setChildrenLoaded(false);
        }
    }

    private void removeNode(Fqn fqn) {
        InternalNode targetNode = this.peekInternalNode(fqn, true);
        if (targetNode == null) {
            return;
        }
        InternalNode parentNode = this.peekInternalNode(fqn.getParent(), true);
        targetNode.setValid(false, false);
        if (parentNode != null) {
            parentNode.removeChild(fqn.getLastElement());
            parentNode.setChildrenLoaded(false);
        }
    }

    private void removeDataLegacy(Fqn fqn) {
        NodeSPI n = this.peek(fqn);
        if (n == null) {
            log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        n.clearDataDirect();
        n.setDataLoaded(false);
    }

    private void removeData(Fqn fqn) {
        InternalNode n = this.peekInternalNode(fqn, false);
        if (n == null) {
            log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        n.clear();
        n.setDataLoaded(false);
    }

    @Override
    public Object[] createNodes(Fqn fqn) {
        ArrayList result = new ArrayList(fqn.size());
        Fqn<Object> tmpFqn = Fqn.ROOT;
        int size = fqn.size();
        NodeSPI n = this.root;
        for (int i = 0; i < size; ++i) {
            Object childName = fqn.get(i);
            tmpFqn = Fqn.fromRelativeElements(tmpFqn, childName);
            Map children = n.getChildrenMapDirect();
            NodeSPI childNode = (NodeSPI)children.get(childName);
            if (childNode == null) {
                childNode = n.addChildDirect(Fqn.fromElements(childName));
                result.add(childNode);
            }
            n = childNode;
        }
        return new Object[]{result, n};
    }

    @Override
    public InternalNode peekInternalNode(Fqn fqn, boolean includeInvalidNodes) {
        if (fqn == null || fqn.size() == 0) {
            return this.rootInternal;
        }
        InternalNode n = this.rootInternal;
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChild(obj)) == null) {
                return null;
            }
            if (includeInvalidNodes || n.isValid()) continue;
            return null;
        }
        return n;
    }

    @Override
    public InternalNode[] peekInternalNodeAndDirectParent(Fqn fqn, boolean includeInvalidNodes) {
        if (fqn == null || fqn.size() == 0) {
            return new InternalNode[]{this.rootInternal, null};
        }
        InternalNode n = this.rootInternal;
        InternalNode directParent = null;
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            directParent = n;
            Object obj = fqn.get(i);
            if ((n = directParent.getChild(obj)) == null) {
                return NULL_ARRAY;
            }
            if (includeInvalidNodes || n.isValid()) continue;
            return NULL_ARRAY;
        }
        return new InternalNode[]{n, directParent};
    }

    public void setBuddyFqnTransformer(BuddyFqnTransformer buddyFqnTransformer) {
        this.buddyFqnTransformer = buddyFqnTransformer;
    }
}

